package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.NutritionCollectReqDto;
import com.dtyunxi.tcbj.api.dto.response.NutritionOrderCollectRespDto;
import com.dtyunxi.tcbj.center.openapi.common.eas.dto.EASBillReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@Api(tags = {"报表中心：营养家汇总推送EAS服务"})
@FeignClient(
        contextId = "com-dtyunxi-tcbj-api-INutritionCollectApi",
        name = "${tcbj.center.report.api.name:tcbj-center-report}",
        path = "/v1/nutritionCollect",
        url = "${tcbj.center.report.api:}"
)
public interface INutritionCollectApi {

    /**
     * 营养家汇总查询
     * @param reqDto 请求参数
     * @return 处理结果
     */
    @PostMapping("/execute")
    @ApiOperation(value = "营养家汇总查询", notes = "营养家汇总查询")
    RestResponse<List<NutritionOrderCollectRespDto>> execute(@RequestBody NutritionCollectReqDto reqDto);
}
