package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.ReInsuranceBillReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
* 保费账单表服务接口
*
* @author lshaowu
* @since 2022-07-18
*/
@Api(tags = {"保费账单表服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-IReInsuranceBillApi",
    name = "tcbj-center-report",
    path = "/v1/reInsuranceBill",
    url = "${tcbj.center.report.api:}"
)
public interface IReInsuranceBillApi {

/**
* 新增保费账单表
*
* @param addReqDto 保费账单表请求对象
* @return 处理结果
*/
@PostMapping("")
@ApiOperation(value = "新增保费账单表", notes = "新增保费账单表")
RestResponse<Long> addReInsuranceBill(@RequestBody ReInsuranceBillReqDto addReqDto);

    /**
    * 修改保费账单表
    *
    * @param modifyReqDto 保费账单表请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改保费账单表", notes = "修改保费账单表")
    RestResponse<Void> modifyReInsuranceBill(@RequestBody ReInsuranceBillReqDto modifyReqDto);

    /**
    * 删除保费账单表
    *
    * @param ids        保费账单表删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除保费账单表", notes = "删除保费账单表")
    RestResponse<Void> removeReInsuranceBill(@PathVariable("ids") String ids,@RequestParam("instanceId") Long instanceId);
}
