package com.dtyunxi.tcbj.api.dto.constant.enums;

/**
 * 账单分摊其他费用操作方式
 * @author lius5
 */
public enum ApportionOtherOperationEnum {

    APPORTION_DATA(0, "获取分摊数据"),
    VERIFY(1, "校验当前仓库是否参与分摊其他费用"),
    COMMIT(2, "覆盖更新分摊其他费用金额"),
    ;

    private Integer key;

    private String desc;

    public Integer getKey() {
        return key;
    }

    public void setKey(Integer key) {
        this.key = key;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    ApportionOtherOperationEnum(Integer key, String desc) {
        this.key = key;
        this.desc = desc;
    }

    public static ApportionOtherOperationEnum keyOfEnum(Integer key) {
        for (ApportionOtherOperationEnum apportionOtherOperationEnum : ApportionOtherOperationEnum.values()) {
            if(apportionOtherOperationEnum.getKey().equals(key)){
                return apportionOtherOperationEnum;
            }
        }
        return null;
    }
}
