package com.dtyunxi.tcbj.api.dto.constant.enums;

/**
 * @author minyue
 * @description: 赠品余额流水(交易类型)
 * @since 2022-01-08 18:07
 */
public enum GiftBalanceStatementTradeTypeEnum {
    ORDER_GIFT("01", "下单赠送"),
    ORDER_DEDUCT("02", "订单抵扣"),
    ORDER_RETURN("03", "订单退回"),
    ORDER_REDUCE("04", "退货扣减"),
    ADVANCE_GRANT("05", "预支额度发放"),
    ADVANCE_RETURN("06", "预支额度归还"),
    GIVE_RETURN("07", "赠送退回"),
    MANUAL_IMPORT("08", "人工导入");



    private String status;

    private String value;

    GiftBalanceStatementTradeTypeEnum(String status, String value) {
        this.status = status;
        this.value = value;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}
