package com.dtyunxi.tcbj.api.dto.request;

import com.dtyunxi.tcbj.api.dto.entity.BasePageDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Getter
@Setter
@ApiModel(value = "InspectionReleaseLogicInventoryReqDto", description = "待检放行请求对象")
public class InspectionReleaseLogicInventoryReqDto extends BasePageDto {

    /**
     * 前端tab页标记
     * wait_release(待放行),
     * pre_release(预放行),
     * has_release(已放行),
     * unqualified(待放行-不合格),
     * over_2days_not_submit(待放行-超2天未提单),
     * over_7days_not_report(待放行-超7天未出报告),
     * over_3days_not_release(待放行-超3天未放行),
     * balance_gt_plan(待放行-在库比计划多),
     * balance_lt_plan(待放行-在库比计划少),
     * pre_release_over_7days_not_report(预放行-超7天未出报告)
     * wait_release_plan_in_diff(待放行-计划与入库差异)
     * pre_release_plan_in_diff(预放行-计划与入库差异)
     * has_release_plan_release_diff(已放行-计划与实际差异)
     */
    private String tab;

    /**
     * 货品编码
     */
    @ApiModelProperty(name = "cargoCode", value = "货品编码")
    private String cargoCode;

    private List<String> cargoCodes;

    /**
     * 货品名称
     */
    @ApiModelProperty(name = "cargoName", value = "货品名称")
    private String cargoName;

    /**
     * 货品规格
     */
    @ApiModelProperty(name = "specification", value = "货品规格")
    private String specification;

    /**
     * 货品批次
     */
    @ApiModelProperty(name = "batch", value = "货品批次")
    private String batch;

    private List<String> batches;

    /**
     * 标签
     */
    @ApiModelProperty(name = "tag", value = "标签")
    private List<String> tag;

    /**
     * 备注
     */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    /**
     * 报告结果
     */
    @ApiModelProperty(name = "reportResult", value = "报告结果")
    private String reportResult;

    /**
     * 在库与计划差异
     */
    @ApiModelProperty(name = "balanceDiffPlanNum", value = "在库与计划差异")
    private BigDecimal balanceDiffPlanNum;

    /**
     * 状态编码
     */
    @ApiModelProperty(name = "status", value = "状态编码")
    private Integer status;

    /**
     * 任务状态编码
     */
    @ApiModelProperty(name = "taskStatus", value = "任务状态编码")
    private String taskStatus;


    private List<Integer> statusList;

    /**
     * 超2天未提单
     */
    @ApiModelProperty(name = "over2DaysNotSubmit", value = "超2天未提单")
    private Boolean over2DaysNotSubmit;
    /**
     * 超7天未出报告
     */
    @ApiModelProperty(name = "over7DaysNotReport", value = "超7天未出报告")
    private Boolean over7DaysNotReport;
    /**
     * 超3天未放行
     */
    @ApiModelProperty(name = "over3DaysNotRelease", value = "超3天未放行")
    private Boolean over3DaysNotRelease;

    /**
     * 放行单号
     */
    private String inspectionReleaseNo;

    /**
     * 报告开始时间
     */
    private Date reportBeginTime;

    /**
     * 报告结束时间
     */
    private Date reportEndTime;

    /**
     * 放行开始时间
     */
    private Date releaseBeginTime;

    /**
     * 放行结束时间
     */
    private Date releaseEndTIme;

    private Boolean balanceGtPlan;

    private Boolean balanceLtPlan;

    private Boolean releaseDiff;

    private Boolean batchUnfair;

    private Boolean planReleaseNumDiffIn;

    private Boolean planReleaseNumDiffEndRelease;
}
