package com.dtyunxi.tcbj.api.dto.request;

import java.util.Date;
import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;

/**
* 放行单Eo对象
*
* @author 紫霄
* @since 2023-05-11
*/
@ApiModel(value = "InspectionReleaseOrderReqDto", description = "放行单Eo对象")
public class InspectionReleaseOrderReqDto extends RequestDto{
    /**
    *  主键id
    */
    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;
    /**
    *  放行单号
    */
    @ApiModelProperty(name = "inspectionReleaseNo", value = "放行单号")
    private String inspectionReleaseNo;
    /**
    *  运单类型：1:预放行 2:正常放行
    */
    @ApiModelProperty(name = "inspectionReleaseType", value = "运单类型：1:预放行 2:正常放行")
    private Integer inspectionReleaseType;
    /**
    *  质检报告委托编号
    */
    @ApiModelProperty(name = "qualityInspectionNo", value = "质检报告委托编号")
    private String qualityInspectionNo;
    /**
    *  质检报告时间
    */
    @ApiModelProperty(name = "qualityInspectionDate", value = "质检报告时间")
    private Date qualityInspectionDate;
    /**
    *  SKU code
    */
    @ApiModelProperty(name = "skuCode", value = "SKU code")
    private String skuCode;
    /**
    *  SKU 名称
    */
    @ApiModelProperty(name = "skuName", value = "SKU 名称")
    private String skuName;
    /**
    *  SKU 规格
    */
    @ApiModelProperty(name = "skuSpec", value = "SKU 规格")
    private String skuSpec;
    /**
    *  批次
    */
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;
    /**
    *  计划放行数量
    */
    @ApiModelProperty(name = "planReleaseNum", value = "计划放行数量")
    private BigDecimal planReleaseNum;
    /**
    *  放行数量
    */
    @ApiModelProperty(name = "releaseNum", value = "放行数量")
    private BigDecimal releaseNum;
    /**
    *  放行单状态 0:预放行, 1:已放行, 2:不合格, 3:已撤销
    */
    @ApiModelProperty(name = "orderStatus", value = "放行单状态 0:预放行, 1:已放行, 2:不合格, 3:已撤销")
    private Integer orderStatus;
    /**
    *  备注
    */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }
    public void setInspectionReleaseNo(String inspectionReleaseNo){
    this.inspectionReleaseNo = inspectionReleaseNo;
    }
    public String getInspectionReleaseNo(){
    return this.inspectionReleaseNo;
    }
    public void setInspectionReleaseType(Integer inspectionReleaseType){
    this.inspectionReleaseType = inspectionReleaseType;
    }
    public Integer getInspectionReleaseType(){
    return this.inspectionReleaseType;
    }
    public void setQualityInspectionNo(String qualityInspectionNo){
    this.qualityInspectionNo = qualityInspectionNo;
    }
    public String getQualityInspectionNo(){
    return this.qualityInspectionNo;
    }
    public void setQualityInspectionDate(Date qualityInspectionDate){
    this.qualityInspectionDate = qualityInspectionDate;
    }
    public Date getQualityInspectionDate(){
    return this.qualityInspectionDate;
    }
    public void setSkuCode(String skuCode){
    this.skuCode = skuCode;
    }
    public String getSkuCode(){
    return this.skuCode;
    }
    public void setSkuName(String skuName){
    this.skuName = skuName;
    }
    public String getSkuName(){
    return this.skuName;
    }
    public void setSkuSpec(String skuSpec){
    this.skuSpec = skuSpec;
    }
    public String getSkuSpec(){
    return this.skuSpec;
    }
    public void setBatch(String batch){
    this.batch = batch;
    }
    public String getBatch(){
    return this.batch;
    }
    public void setPlanReleaseNum(BigDecimal planReleaseNum){
    this.planReleaseNum = planReleaseNum;
    }
    public BigDecimal getPlanReleaseNum(){
    return this.planReleaseNum;
    }
    public void setReleaseNum(BigDecimal releaseNum){
    this.releaseNum = releaseNum;
    }
    public BigDecimal getReleaseNum(){
    return this.releaseNum;
    }
    public void setOrderStatus(Integer orderStatus){
    this.orderStatus = orderStatus;
    }
    public Integer getOrderStatus(){
    return this.orderStatus;
    }
    public void setRemark(String remark){
    this.remark = remark;
    }
    public String getRemark(){
    return this.remark;
    }
}
