/*
 * @(#)VirtualInventoryQueryReqDto.java 1.0 2022年07月12日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.tcbj.api.dto.request;

import com.dtyunxi.dto.BasePageDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>Title:VirtualInventoryQueryReqDto</p>
 * <p>Description:虚拟仓库存查询DTO对象 </p>
 *
 * @author guigu.qjr
 * @date 2022/7/12
 * @since 0.1.0
 */
@ApiModel(value = "InventoryQueryReqDto", description = "虚拟仓库存查询DTO对象")
@Data
public class InventoryQueryReqDto extends BasePageDto {
    /**
     *  仓库ID
     */
    @ApiModelProperty(name = "cargoCode", value = "货品编码")
    private String cargoCode;

    @ApiModelProperty(name = "cargoCodes", value = "货品编码集合")
    private List<String> cargoCodes;
    /**
     *  仓库编码
     */
    @ApiModelProperty(name = "cargoName", value = "货品名称")
    private String cargoName;

    /**
     *  仓库名称
     */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;

    @ApiModelProperty(name = "warehouseCodes", value = "仓库编码集合")
    private List<String> warehouseCodes;

    /**
     *  仓库名称
     */
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;

    /**
     *  库存>0
     */
    @ApiModelProperty(name="isExceedZero", value = "库存>0")
    private String isExceedZero;

    /**
     *  搜索维度
     */
    @ApiModelProperty(name = "searchDimension", value = "搜索维度, 总库存：balance,预占库存：preempt， 可用库存：available")
    private String searchDimension;


    /**
     *  搜索数量范围：最小数量
     */
    @ApiModelProperty(name = "minQuantity", value = "搜索数量范围：最小数量")
    private BigDecimal minQuantity;

    /**
     *  搜索数量范围：最大数量
     */
    @ApiModelProperty(name = "maxQuantity", value = "搜索数量范围：最大数量")
    private BigDecimal maxQuantity;

    /**
     *  管控商品
     */
    @ApiModelProperty(name = "controlItem", value = "管控商品")
    private Boolean controlItem;


    /**
     *  仓库名称
     */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCodeEq;

}

