package com.dtyunxi.tcbj.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author minyue
 * @description: 促销活动汇总
 * @since 2022-01-13 17:49
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "PromotionalActivitiesStatisticsReqDto", description = "促销活动汇总")
public class PromotionalActivitiesStatisticsReqDto extends ReportBrandBaseReqDto {

    @ApiModelProperty(name = "placeTimeStart", value = "时间起(年月)")
    private String placeTimeStart;

    @ApiModelProperty(name = "placeTimeEnd", value = "时间(年月)")
    private String placeTimeEnd;

    @ApiModelProperty(name = "itemType", value = "商品类型")
    private Integer itemType;

    @ApiModelProperty(name = "activityType", value = "活动类型")
    private String activityType;

    @ApiModelProperty(name = "activityName", value = "促销活动名称")
    private String activityName;

    @ApiModelProperty(name = "activityCode", value = "促销活动编码")
    private String activityCode;

    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;

    @ApiModelProperty(name = "itemCode", value = "商品编码")
    private String itemCode;
}
