package com.dtyunxi.tcbj.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * @author jack
 * @version 1.0
 * @date 02/09/2022 19:17
 **/
@ApiModel(value = "SkuInventoryReqDto", description = "sku库存统计请求对象")
@Getter
@Setter
public class SkuInventoryReqDto {

    @ApiModelProperty(name = "key", value = "提取key")
    private String key;

    @ApiModelProperty(name = "skuCode", value = "货品编码")
    private String skuCode;

    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;

    @ApiModelProperty(name = "warehouseCode", value = "逻辑仓库编码")
    private String warehouseCode;

    @ApiModelProperty(name = "warehouseName", value = "逻辑仓库名称")
    private String warehouseName;


    @ApiModelProperty(name = "physicsWarehouseCode", value = "物理仓库编码")
    private String physicsWarehouseCode;

    private String physicsWarehouseName;

    @ApiModelProperty(name = "organizationCode", value = "组织编码")
    private String organizationCode;

    /**
     * 是否查询快照
     */
    @ApiModelProperty(name = "querySnap", value = "是否查询快照 1 是 0 否")
    private Integer querySnap = 0;


    /**
     * 是否主仓
     */
    @ApiModelProperty(name = "mainWarehouse", value = "是否查询主仓 0 是 1 否")
    private Integer mainWarehouse;

    @ApiModelProperty(name = "warehouseQuality", value = "仓库品质")
    private String warehouseQuality;

}
