package com.dtyunxi.tcbj.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.tcbj.api.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
@ApiModel(value = "TransferOrderReportReqDto", description = "DTO")
public class TransferOrderReportReqDto extends BaseDto {

    @ApiModelProperty(name = "preOrderNo", value = "外部单号")
    private String preOrderNo;

    @ApiModelProperty(name = "parentOrderNo", value = "外部父单号")
    private String parentOrderNo;

    @ApiModelProperty(name = "transferOrderNo", value = "调拨单号")
    private String transferOrderNo;

    @ApiModelProperty(name = "orderStatus", value = "单据状态")
    private String orderStatus;

    @ApiModelProperty(name = "outWarehouse", value = "调出逻辑仓名称")
    private String outWarehouse;

    @ApiModelProperty(name = "inWarehouse", value = "调入逻辑仓名称")
    private String inWarehouse;

    @ApiModelProperty(name = "outPhysicsWarehouseCode", value = "调出物理仓编码")
    private String outPhysicsWarehouseCode;

    @ApiModelProperty(name = "outPhysicsWarehouseCodeList", value = "调出物理仓编码")
    private List<String> outPhysicsWarehouseCodeList;

    @ApiModelProperty(name = "outPhysicsWarehouseName", value = "调出物理仓名称")
    private String outPhysicsWarehouseName;

    @ApiModelProperty(name = "inPhysicsWarehouseCode", value = "调入物理仓编码")
    private String inPhysicsWarehouseCode;

    @ApiModelProperty(name = "inPhysicsWarehouseCodeList", value = "调入物理仓编码")
    private List<String> inPhysicsWarehouseCodeList;

    @ApiModelProperty(name = "inPhysicsWarehouseName", value = "调入物理仓名称")
    private String inPhysicsWarehouseName;

    @ApiModelProperty(name = "outInventoryOrg", value = "调出库存组织")
    private String outInventoryOrg;

    @ApiModelProperty(name = "inInventoryOrg", value = "调入库存组织")
    private String inInventoryOrg;

    @ApiModelProperty(name = "goodsName", value = "商品名称")
    private String goodsName;

    @ApiModelProperty(name = "longCode", value = "商品长编码")
    private String longCode;

    @ApiModelProperty(name = "batchNo", value = "批次")
    private String batchNo;

    @ApiModelProperty(name = "productStartDate", value = "生产开始日期")
    private String productStartDate;

    @ApiModelProperty(name = "productEndDate", value = "生产结束日期")
    private String productEndDate;

    @ApiModelProperty(name = "expireStartDate", value = "到期开始日期")
    private String expireStartDate;

    @ApiModelProperty(name = "expireEndDate", value = "到期结束日期")
    private String expireEndDate;

    @ApiModelProperty(name = "createStartTime", value = "创建开始时间")
    private Date createStartTime;

    @ApiModelProperty(name = "createEndTime", value = "创建结束时间")
    private Date createEndTime;

    private String type;

    private List<String> types;

    private List<String> excludeTypes;

    @ApiModelProperty(name = "ifDelivery", value = "是否已出库，1是，0否")
    private Integer ifDelivery;
}
