package com.dtyunxi.tcbj.api.dto.response;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.Date;

/**
* 出/入库通知单明细Eo对象
*
* @author 天泽
* @since 2022-08-30
*/
@Getter
@Setter
@ApiModel(value = "CsOutNoticeOrderDetailRespDto", description = "出/入库通知单明细Eo对象")
public class CsOutNoticeOrderDetailRespDto extends BaseRespDto{
    /**
    *  主键id
    */
    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;
    /**
    *  出/入库通知单号
    */
    @ApiModelProperty(name = "documentNo", value = "出/入库通知单号")
    private String documentNo;
    /**
    *  关联单据号
    */
    @ApiModelProperty(name = "relevanceNo", value = "关联单据号")
    private String relevanceNo;
    /**
    *  前置单号
    */
    @ApiModelProperty(name = "preOrderNo", value = "前置单号")
    private String preOrderNo;
    /**
    *  第三方单据号
    */
    @ApiModelProperty(name = "externalOrderNo", value = "第三方单据号")
    private String externalOrderNo;

    private String easOrderNo;
    private String platformOrderNo;
    private String splitPlatformNo;
    private String saleOrderNo;
    /**
    *  wms单号
    */
    @ApiModelProperty(name = "wmsOrderNo", value = "wms单号")
    private String wmsOrderNo;
    /**
    *  货品ID
    */
    @ApiModelProperty(name = "cargoId", value = "货品ID")
    private Long cargoId;
    /**
    *  商品长编码
    */
    @ApiModelProperty(name = "longCode", value = "商品长编码")
    private String longCode;

    @ApiModelProperty(name = "skuCode", value = "商品长编码")
    private String skuCode;
    /**
    *  货品编码
    */
    @ApiModelProperty(name = "cargoCode", value = "货品编码")
    private String cargoCode;
    /**
    *  货品名称
    */
    @ApiModelProperty(name = "cargoName", value = "货品名称")
    private String cargoName;
    /**
    *  货品货号
    */
    @ApiModelProperty(name = "artNo", value = "货品货号")
    private String artNo;
    /**
    *  批次
    */
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;
    /**
    *  原始计划出/入库数量
    */
    @ApiModelProperty(name = "originPlanQuantity", value = "原始计划出/入库数量")
    private BigDecimal originPlanQuantity;
    /**
    *  计划出/入库数量
    */
    @ApiModelProperty(name = "planQuantity", value = "计划出/入库数量")
    private BigDecimal planQuantity;
    /**
    *  待出/入库数量
    */
    @ApiModelProperty(name = "waitQuantity", value = "待出/入库数量")
    private BigDecimal waitQuantity;
    /**
    *  已出/入库数量
    */
    @ApiModelProperty(name = "doneQuantity", value = "已出/入库数量")
    private BigDecimal doneQuantity;
    /**
    *  取消总数量
    */
    @ApiModelProperty(name = "cancelQuantity", value = "取消总数量")
    private BigDecimal cancelQuantity;
    /**
    *  备注
    */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    /**
    *  活动ID,只有是活动类型的商品才有值
    */
    @ApiModelProperty(name = "activityId", value = "活动ID,只有是活动类型的商品才有值")
    private Long activityId;

    @ApiModelProperty(name = "produceTime", value = "生产日期")
    private Date produceTime;
    @ApiModelProperty(name = "expireTime", value = "过期日期")
    private Date expireTime;

}
