
package com.dtyunxi.tcbj.api.dto.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.validation.Valid;
import lombok.Data;

/**
 * InventoryDetailReportPageListRespDto
 *
 * @author fengjian
 */
@Data
@ApiModel(value = "InventoryDetailReportPageListRespDto", description = "")
public class InventoryDetailReportPageListRespDto implements Serializable {


    @ApiModelProperty(name = "id", value = "唯一id")
    @JsonProperty("id")
    private Long id = null;


    @ApiModelProperty(name = "statisticsTime", value = "统计时间")
    @JsonProperty("statisticsTime")
    private Date statisticsTime;

  @ApiModelProperty(name="externalOrderNo", value = "外部单号")
  @JsonProperty("externalOrderNo")
  private String externalOrderNo;


  @ApiModelProperty(name="sourceSystem", value = "系统来源")
  @JsonProperty("sourceSystem")
  private String sourceSystem;


  @ApiModelProperty(name="orderType", value = "单据类型")
  @JsonProperty("orderType")
  private String orderType;


  @ApiModelProperty(name="documentNo", value = "出入库单号")
  @JsonProperty("documentNo")
  private String documentNo;


  @ApiModelProperty(name="businessType", value = "业务类型")
  @JsonProperty("businessType")
  private String businessType;


  @ApiModelProperty(name="businessOrderNo", value = "关联业务单号")
  @JsonProperty("businessOrderNo")
  private String businessOrderNo;


  @ApiModelProperty(name="goodsLongCode", value = "商品长编码")
  @JsonProperty("goodsLongCode")
  private String goodsLongCode;


  @ApiModelProperty(name="goodsName", value = "商品名称")
  @JsonProperty("goodsName")
  private String goodsName;


  @ApiModelProperty(name="batch", value = "批次")
  @JsonProperty("batch")
  private String batch;


  @ApiModelProperty(name="logicalWarehouseCode", value = "入库逻辑仓编码")
  @JsonProperty("logicalWarehouseCode")
  private String logicalWarehouseCode;


  @ApiModelProperty(name="logicalWarehouseName", value = "入库逻辑仓名称")
  @JsonProperty("logicalWarehouseName")
  private String logicalWarehouseName;


  @ApiModelProperty(name="cargoRightCode", value = "库存组织编码")
  @JsonProperty("cargoRightCode")
  private String cargoRightCode;


  @ApiModelProperty(name="cargoRightId", value = "库存组织id")
  @JsonProperty("cargoRightId")
  private String cargoRightId;


  @ApiModelProperty(name="cargoRightName", value = "库存组织名称")
  @JsonProperty("cargoRightName")
  private String cargoRightName;


  @Valid
  @ApiModelProperty(name="inventoryQuantity", value = "库存数量")
  @JsonProperty("inventoryQuantity")
  private BigDecimal inventoryQuantity;


    @ApiModelProperty(name = "produceTime", value = "生产日期")
    @JsonProperty("produceTime")
    private Date produceTime;


    @ApiModelProperty(name = "expireTime", value = "到期日期")
    @JsonProperty("expireTime")
    private Date expireTime;

    @ApiModelProperty(name = "createTime", value = "订单创建时间")
    @JsonProperty("createTime")
    private Date createTime;

  @ApiModelProperty(name="physicsWarehouseCode", value = "物理仓编码")
  @JsonProperty("physicsWarehouseCode")
  private String physicsWarehouseCode;


  @ApiModelProperty(name="physicsWarehouseName", value = "物理仓名称")
  @JsonProperty("physicsWarehouseName")
  private String physicsWarehouseName;

}

