package com.dtyunxi.tcbj.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @author minyue
 * @description: 经销商报表-订单销售进度表
 * @since 2021-12-30 14:50
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "OrderSaleprogressRespDto", description = "订单销售进度表")
public class OrderSaleProgressRespDto extends ReportBaseRespDto {

    @ApiModelProperty(name = "target", value = "目标")
    private BigDecimal target;

    @ApiModelProperty(name = "orderNum", value = "数量")
    private Integer orderNum;

    @ApiModelProperty(name = "orderPayAmount", value = "金额")
    private BigDecimal orderPayAmount;

    @ApiModelProperty(name = "targetCompletionRate", value = "目标完成率")
    private BigDecimal targetCompletionRate;

    @ApiModelProperty(name = "orderNumOfLastYear", value = "去年同期数量")
    private Integer orderNumOfLastYear;

    @ApiModelProperty(name = "orderPayAmountOfLastYear", value = "去年同期金额")
    private BigDecimal orderPayAmountOfLastYear;

    @ApiModelProperty(name = "rateOfRise", value = "增长率")
    private BigDecimal rateOfRise;

    @ApiModelProperty(name = "parentAreaSum", value = "大区合计")
    private Integer parentAreaSum;

    @ApiModelProperty(name = "customerAreaSum", value = "区域合计")
    private Integer customerAreaSum;
}
