package com.dtyunxi.tcbj.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 仓储账单打印Dto
 * @author lius5
 *
 */
@ApiModel(value = "StorageChargeBillPrintDto", description = "仓储账单打印Dto")
public class StorageChargeBillPrintDto {

    /**
     *  库存时间
     */
    @ApiModelProperty(name = "storageTime", value = "库存时间")
    private Date storageTime;
    /**
     *  托盘数
     */
    @ApiModelProperty(name = "support", value = "占板数")
    private BigDecimal support;

    /**
     *  单价
     */
    @ApiModelProperty(name = "unitPrice", value = "单价")
    private BigDecimal unitPrice;

    /**
     *  仓租
     */
    @ApiModelProperty(name = "warehouseCost", value = "仓租")
    private BigDecimal warehouseCost;

    /**
     *  计费组织
     */
    @ApiModelProperty(name = "chargeOrgName", value = "计费组织")
    private String chargeOrgName;

    public Date getStorageTime() {
        return storageTime;
    }

    public void setStorageTime(Date storageTime) {
        this.storageTime = storageTime;
    }

    public BigDecimal getSupport() {
        return support;
    }

    public void setSupport(BigDecimal support) {
        this.support = support;
    }

    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    public BigDecimal getWarehouseCost() {
        return warehouseCost;
    }

    public void setWarehouseCost(BigDecimal warehouseCost) {
        this.warehouseCost = warehouseCost;
    }

    public String getChargeOrgName() {
        return chargeOrgName;
    }

    public void setChargeOrgName(String chargeOrgName) {
        this.chargeOrgName = chargeOrgName;
    }
}
