package com.dtyunxi.tcbj.api.dto.response;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 业务类型表Eo对象
 *
 * @author wuyue
 * @since 2022-05-17
 */
@Data
@ApiModel(value = "CsTransferOrderRespDto", description = "业务类型表Eo对象")
public class TransferOrderReportRespDto extends BaseRespDto {

    @ApiModelProperty(name = "transferOrderNo", value = "调拨单号")
    private String transferOrderNo;

    @ApiModelProperty(name = "preOrderNo", value = "外部单号")
    private String preOrderNo;

    @ApiModelProperty(name = "parentOrderNo", value = "外部父单号")
    private String parentOrderNo;

    @ApiModelProperty(name = "easNo", value = "EAS出库单号")
    private String easNo;

    @ApiModelProperty(name = "externalSaleOrderNo", value = "外部销售单号 ")
    private String externalSaleOrderNo;

    @ApiModelProperty(name = "externalPurchaseOrderNo", value = "外部采购单号 ")
    private String externalPurchaseOrderNo;

    @ApiModelProperty(name = "type", value = "类型 ")
    private String type;

    @ApiModelProperty(name = "orderStatus", value = "单据状态")
    private String orderStatus;

    @ApiModelProperty(name = "outWarehouseCode", value = "调出逻辑仓编码")
    private String outWarehouseCode;

    @ApiModelProperty(name = "outWarehouse", value = "调出逻辑仓名称")
    private String outWarehouse;

    @ApiModelProperty(name = "inWarehouseCode", value = "调入逻辑仓编码")
    private String inWarehouseCode;

    @ApiModelProperty(name = "inWarehouse", value = "调入逻辑仓名称")
    private String inWarehouse;

    @ApiModelProperty(name = "outPhysicsWarehouseCode", value = "调出物理仓编码")
    private String outPhysicsWarehouseCode;

    @ApiModelProperty(name = "outPhysicsWarehouseName", value = "调出物理仓名称")
    private String outPhysicsWarehouseName;

    @ApiModelProperty(name = "inPhysicsWarehouseCode", value = "调入物理仓编码")
    private String inPhysicsWarehouseCode;

    @ApiModelProperty(name = "inPhysicsWarehouseName", value = "调入物理仓名称")
    private String inPhysicsWarehouseName;

    @ApiModelProperty(name = "outInventoryOrg", value = "调出库存组织")
    private String outInventoryOrg;

    @ApiModelProperty(name = "outInventoryOrgId", value = "调出库存组织id")
    private Long outInventoryOrgId;

    @ApiModelProperty(name = "inInventoryOrg", value = "调入库存组织")
    private String inInventoryOrg;

    @ApiModelProperty(name = "inInventoryOrgId", value = "调入库存组织id")
    private Long inInventoryOrgId;

    @ApiModelProperty(name = "goodsName", value = "商品名称")
    private String goodsName;

    @ApiModelProperty(name = "longCode", value = "商品长编码")
    private String longCode;

    @ApiModelProperty(name = "batchNo", value = "批次")
    private String batchNo;

    @ApiModelProperty(name = "productDate", value = "生产日期")
    private String productDate;

    @ApiModelProperty(name = "expireDate", value = "到期日期")
    private String expireDate;

    @ApiModelProperty(name = "planQuantity", value = "计划数量")
    private BigDecimal planQuantity;

    @ApiModelProperty(name = "disposeQuantity", value = "已处理数量")
    private BigDecimal disposeQuantity;

    @ApiModelProperty(name = "disposeEnterQuantity", value = "已处理数量（入）")
    private BigDecimal disposeEnterQuantity;

    @ApiModelProperty(name = "createPerson", value = "创建人")
    private String createPerson;

    @ApiModelProperty(name = "createTime", value = "创建时间")
    private Date createTime;


    @ApiModelProperty(name = "address", value = "客户地址")
    private String address;

    @ApiModelProperty(name = "customerName", value = "客户名称")
    private String customerName;

    @ApiModelProperty(name = "startCity", value = "起运地")
    private String startCity;

    @ApiModelProperty(name = "customerName", value = "目的地")
    private String city;

    @ApiModelProperty(name = "totalWeight", value = "重量")
    private BigDecimal totalWeight;

    @ApiModelProperty(name = "totalVolume", value = "体积")
    private BigDecimal totalVolume;

    @ApiModelProperty(name = "totalCartons", value = "总箱数")
    private BigDecimal totalCartons;

    @ApiModelProperty(name = "mergeQuantity", value = "拼箱数")
    private BigDecimal mergeQuantity;

    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    private String documentNo;

}
