package com.dtyunxi.tcbj.api.dto.response.es;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 入库通知单实体
 */
@Data
@ApiModel(value = "InNoticeOrderVO", description = "入库通知单实体")
public class InNoticeOrderVO {

    @ApiModelProperty(name = "id", value = "唯一id")
    @JsonProperty("id")
    private Long id;

    @ApiModelProperty(name = "documentNo", value = "入库通知单号")
    @JsonProperty("documentNo")
    private String documentNo;

    @ApiModelProperty(name = "relevanceNo", value = "关联单据号")
    @JsonProperty("relevanceNo")
    private String relevanceNo;

    @ApiModelProperty(name = "preOrderNo", value = "前置单号")
    @JsonProperty("preOrderNo")
    private String preOrderNo;
    @ApiModelProperty(name = "externalOrderNo", value = "外部单号")
    @JsonProperty("externalOrderNo")
    private String externalOrderNo;

    @ApiModelProperty(name = "documentStatus", value = "单据状态")
    @JsonProperty("documentStatus")
    private String documentStatus;

    @ApiModelProperty(name = "organizationId", value = "组织ID")
    private Long organizationId;

    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;

    @ApiModelProperty(name = "businessType", value = "业务类型")
    @JsonProperty("businessType")
    private String businessType;

    @ApiModelProperty(name = "orderStatus", value = "单据状态")
    private String orderStatus;

    @ApiModelProperty(name = "shopId", value = "收货店铺ID")
    private Long shopId;

    @ApiModelProperty(name = "shopCode", value = "收货店铺编码")
    private String shopCode;

    @ApiModelProperty(name = "shopName", value = "收货店铺名称")
    private String shopName;

    @ApiModelProperty(name = "inLogicWarehouseCode", value = "入库逻辑仓库编码")
    private String inLogicWarehouseCode;

    @ApiModelProperty(name = "inLogicWarehouseName", value = "入库逻辑仓库名称")
    private String inLogicWarehouseName;

    @ApiModelProperty(name = "outLogicWarehouseCode", value = "出库逻辑仓库编码")
    private String outLogicWarehouseCode;

    @ApiModelProperty(name = "outLogicWarehouseName", value = "出库逻辑仓库名称")
    private String outLogicWarehouseName;

    @ApiModelProperty(name = "totalQuantity", value = "入库总数量")
    private BigDecimal totalQuantity;

    @ApiModelProperty(name="totalSku", value = "SKU总数量")
    private BigDecimal totalSku;

    @ApiModelProperty(name = "createTime", value = "创建时间")
    @JsonProperty("createTime")
    private Date createTime;

    private Long createTimeLong;

    @ApiModelProperty(name = "bizDate", value = "业务时间")
    private Date bizDate;

    @ApiModelProperty(name="wmsStatus", value = "wms执行状态:receive：接单；receive_complete：收货完成；shelf_review：上架复核；pick_up：拣货；review：复核；shipped：已发货；")
    @JsonProperty("wmsStatus")
    private String wmsStatus;


}

