package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.BudgetItemReqDto;
import com.dtyunxi.tcbj.api.dto.request.CostCenterReqDto;
import com.dtyunxi.tcbj.api.dto.response.BudgetItemRespDto;
import com.dtyunxi.tcbj.api.dto.response.CostCenterRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
* 预算项目维护服务接口
*/
@Api(tags = {"预算项目维护服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-query-IBudgetItemQueryApi",
    name = "${tcbj.center.report.name:tcbj-center-report}",
    path = "/v1/budgetItem",
    url = "${tcbj.center.report.api:}"
)
public interface IBudgetItemQueryApi {

    /**
     * 预算项目分页数据
     *
     * @param reqDto   预算项目查询条件
     * @return 预算项目分页数据
     */
    @PostMapping("/post/page")
    @ApiOperation(value = "预算项目维护分页数据", notes = "预算项目维护分页数据，filter=BudgetItemReqDto")
    RestResponse<PageInfo<BudgetItemRespDto>> queryByPageByPost(@RequestBody BudgetItemReqDto reqDto);



}
