package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.ExpressCostDeliverQuantityReqDto;
import com.dtyunxi.tcbj.api.dto.response.ExpressCostDeliverQuantityRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

/**
* 快递费用月统计发货量服务接口
*
* @author author
* @since 2025-02-18
*/
@Api(tags = {"快递费用月统计发货量服务"})
@FeignClient(
        contextId = "com-dtyunxi-tcbj-api-IExpressCostDeliverQuantityQueryApi",
        name = "${tcbj.center.report.api.name:tcbj-center-report}",
        path = "/v1/expressCostDeliverQuantity",
        url = "${tcbj.center.report.api:}"
)
public interface IExpressCostDeliverQuantityQueryApi {

    /**
    * 根据id查询快递费用月统计发货量
    *
    * @param id 快递费用月统计发货量id
    * @return   快递费用月统计发货量数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询快递费用月统计发货量", notes = "根据id查询快递费用月统计发货量")
    RestResponse<ExpressCostDeliverQuantityRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 快递费用月统计发货量分页数据
    *
    * @param filter   快递费用月统计发货量查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 快递费用月统计发货量分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "快递费用月统计发货量分页数据", notes = "根据filter查询条件查询快递费用月统计发货量数据，filter=ExpressCostDeliverQuantityReqDto")
    RestResponse<PageInfo<ExpressCostDeliverQuantityRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    @PostMapping("/queryPage")
    @ApiOperation(value = "快递费用月统计发货量分页列表", notes = "快递费用月统计发货量分页列表")
    RestResponse<PageInfo<ExpressCostDeliverQuantityRespDto>> queryPage(@RequestBody ExpressCostDeliverQuantityReqDto reqDto);
}
