package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.QualityInfoReqDto;
import com.dtyunxi.tcbj.api.dto.response.QualityInfoDetailReqDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author tangjiaye
 * @since 2.0.0
 */
@Api(tags = {"报表中心：质检转合格"})
@FeignClient(
        name = "${tcbj.center.report.api.name:tcbj-center-report}",
        path = "/v1/quality",
        url = "${tcbj.center.report.api:}"
)
public interface IQualityInfoQueryApi {

    /**
     * 大账单列表查询
     */
    @PostMapping(value = {"/infoDetailPage"}, produces = "application/json")
    @ApiOperation(value = "质检转合格列表查询", notes = "质检转合格列表查询")
    RestResponse<PageInfo<QualityInfoDetailReqDto>> infoDetailPage(@RequestBody QualityInfoReqDto reqDto);

}
