package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.FinishedInventoryReqDto;
import com.dtyunxi.tcbj.api.dto.response.FinishedInventoryRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
* 成品库存报表服务接口
*
* @author 紫霄
* @since 2022-12-08
*/
@Api(tags = {"成品库存报表服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-IFinishedInventoryApi",
    name = "${tcbj.center.report.api.name:tcbj-center-report}",
    path = "/v1/finishedInventory",
    url = "${tcbj.center.report.api:}"
)
public interface IFinishedInventoryApi {

    /**
    * 新增成品库存报表
    *
    * @param addReqDto 成品库存报表请求对象
    * @return 处理结果
    */
    @PostMapping("")
    @ApiOperation(value = "新增成品库存报表", notes = "新增成品库存报表")
    RestResponse<Long> addFinishedInventory(@RequestBody FinishedInventoryReqDto addReqDto);

    /**
    * 修改成品库存报表
    *
    * @param modifyReqDto 成品库存报表请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改成品库存报表", notes = "修改成品库存报表")
    RestResponse<Void> modifyFinishedInventory(@RequestBody FinishedInventoryReqDto modifyReqDto);

    /**
    * 删除成品库存报表
    *
    * @param ids        成品库存报表删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除成品库存报表", notes = "删除成品库存报表")
    RestResponse<Void> removeFinishedInventory(@PathVariable("ids") String ids,@RequestParam("instanceId") Long instanceId);
}
