package com.dtyunxi.tcbj.api.dto.request;

import com.dtyunxi.tcbj.api.dto.entity.BasePageDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;
@ApiModel(value = "ChannelInventoryReportQueryDto", description = "渠道仓报表查询DTO")
@Data
public class ChannelInventoryReportQueryDto extends BasePageDto {

    @ApiModelProperty(name = "channelWarehouseCodeList", value = "渠道仓编码集合")
    private List<String> channelWarehouseCodeList;

    @ApiModelProperty(name = "cargoCode", value = "货品编码")
    private String cargoCode;

    @ApiModelProperty(name = "cargoName", value = "货品名称")
    private String cargoName;

    @ApiModelProperty(name = "logicAvailableFlag", value = "逻辑仓可用标记 大于0(gtZero)、小于0(ltZero)、等于0(eqZero)、大于等于0(geZero)、小于等于0(leZero)")
    private String logicAvailableFlag;

    @ApiModelProperty(name = "channelAvailableFlag", value = "渠道仓可用标记 大于0(gtZero)、小于0(ltZero)、等于0(eqZero)、大于等于0(geZero)、小于等于0(leZero)")
    private String channelAvailableFlag;

}
