package com.dtyunxi.tcbj.api.dto.request;

import com.alibaba.fastjson.annotation.JSONField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * 物流信息同步dto
 *
 * @author 宁毅
 * @version 1.0
 * @Date 2022/5/7 2:21 下午
 */
@ApiModel(value = "CsLogisticsInfoSyncDto", description = "物流信息同步dto")
public class CsLogisticsInfoSyncDto implements Serializable {

    @ApiModelProperty(name = "dataInfoList", value = "物流数据集合")
    @JSONField(name = "datas")
    private List<DataInfo> dataInfoList;

    public class DataInfo {
        @ApiModelProperty(name = "carrierId", value = "承运商序列号，唯一索引")
        @JSONField(name = "SEQ")
        private String carrierId;

        @ApiModelProperty(name = "type", value = "类型： 1物流，2快递")
        @JSONField(name = "TYPE")
        private Integer type;

        @ApiModelProperty(name = "carrierCode", value = "承运商代码")
        @JSONField(name = "CARRIER_CODE")
        private String carrierCode;

        @ApiModelProperty(name = "carrierName", value = "承运商名称")
        @JSONField(name = "CARRIER_NAME")
        private String carrierName;

        @ApiModelProperty(name = "carrierNo", value = "承运商单号")
        @JSONField(name = "CARRIER_NO")
        private String carrierNo;

        @ApiModelProperty(name = "consignmentNo", value = "托运单号")
        @JSONField(name = "TH_CODE")
        private String consignmentNo;

        @ApiModelProperty(name = "actualArrivalTime", value = "实际到达时间 yyyy-mm-dd hh:mm:ss")
        @JSONField(name = "ACT_TIME")
        private String actualArrivalTime;

        @ApiModelProperty(name = "status", value = "状态 0:提交，1：捡货，2：发货，3：在途，4.签收")
        @JSONField(name = "STATUS")
        private String status;

        @ApiModelProperty(name = "cargoDamageNum", value = "货损数量 ")
        @JSONField(name = "BAD_QTY")
        private String cargoDamageNum;

        @ApiModelProperty(name = "remark", value = "备注 ")
        @JSONField(name = "REMARK")
        private String remark;

        @ApiModelProperty(name = "operTime", value = "操作时间")
        @JSONField(name = "OPER_TIME")
        private String operTime;

        @ApiModelProperty(name = "operAddr", value = "操作地点")
        @JSONField(name = "OPER_ADDR")
        private String operAddr;

        @ApiModelProperty(name = "operPerson", value = "操作人")
        @JSONField(name = "OPER_PERSON")
        private String operPerson;

        @ApiModelProperty(name = "operInfo", value = "操作详情")
        @JSONField(name = "OPER_INFO")
        private String operInfo;

        @ApiModelProperty(name = "pictureUrl", value = "回单图片地址,如果有多张图，可以用逗号分隔")
        @JSONField(name = "PICTURE_URL")
        private String pictureUrl;

        @ApiModelProperty(name = "createTime", value = "创建时间 ")
        @JSONField(name = "CREATE_TIME")
        private String createTime;

        @ApiModelProperty(name = "cspNo", value = "CSP客户订单号")
        @JSONField(name = "CSP_NO")
        private String cspNo;

        public String getCarrierId() {
            return carrierId;
        }

        public void setCarrierId(String carrierId) {
            this.carrierId = carrierId;
        }

        public Integer getType() {
            return type;
        }

        public void setType(Integer type) {
            this.type = type;
        }

        public String getCarrierCode() {
            return carrierCode;
        }

        public void setCarrierCode(String carrierCode) {
            this.carrierCode = carrierCode;
        }

        public String getCarrierName() {
            return carrierName;
        }

        public void setCarrierName(String carrierName) {
            this.carrierName = carrierName;
        }

        public String getCarrierNo() {
            return carrierNo;
        }

        public void setCarrierNo(String carrierNo) {
            this.carrierNo = carrierNo;
        }

        public String getConsignmentNo() {
            return consignmentNo;
        }

        public void setConsignmentNo(String consignmentNo) {
            this.consignmentNo = consignmentNo;
        }

        public String getActualArrivalTime() {
            return actualArrivalTime;
        }

        public void setActualArrivalTime(String actualArrivalTime) {
            this.actualArrivalTime = actualArrivalTime;
        }

        public String getStatus() {
            return status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getCargoDamageNum() {
            return cargoDamageNum;
        }

        public void setCargoDamageNum(String cargoDamageNum) {
            this.cargoDamageNum = cargoDamageNum;
        }

        public String getRemark() {
            return remark;
        }

        public void setRemark(String remark) {
            this.remark = remark;
        }

        public String getOperTime() {
            return operTime;
        }

        public void setOperTime(String operTime) {
            this.operTime = operTime;
        }

        public String getOperAddr() {
            return operAddr;
        }

        public void setOperAddr(String operAddr) {
            this.operAddr = operAddr;
        }

        public String getOperPerson() {
            return operPerson;
        }

        public void setOperPerson(String operPerson) {
            this.operPerson = operPerson;
        }

        public String getOperInfo() {
            return operInfo;
        }

        public void setOperInfo(String operInfo) {
            this.operInfo = operInfo;
        }

        public String getPictureUrl() {
            return pictureUrl;
        }

        public void setPictureUrl(String pictureUrl) {
            this.pictureUrl = pictureUrl;
        }

        public String getCreateTime() {
            return createTime;
        }

        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        public String getCspNo() {
            return cspNo;
        }

        public void setCspNo(String cspNo) {
            this.cspNo = cspNo;
        }
    }

    public List<DataInfo> getDataInfoList() {
        return dataInfoList;
    }

    public void setDataInfoList(List<DataInfo> dataInfoList) {
        this.dataInfoList = dataInfoList;
    }
}
