package com.dtyunxi.tcbj.api.dto.request;

import java.util.Date;
import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
* 物流运费合计记录表Eo对象
*
* @author author
* @since 2022-07-17
*/
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "FinLogisticsReportReqDto", description = "物流运费合计记录表Eo对象")
public class FinLogisticsReportReqDto extends RequestDto{
    /**
    *  主键
    */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;
    /**
    *  类型
    */
    @ApiModelProperty(name = "type", value = "类型")
    private String type;
    /**
    *  出库时间
    */
    @ApiModelProperty(name = "outboundTime", value = "出库时间")
    private Date outboundTime;

    /**
    *  出库单号
    */
    @ApiModelProperty(name = "outNoticeCode", value = "出库通知单号")
    private String outNoticeCode;

    /**
    *  出库单号
    */
    @ApiModelProperty(name = "outboundCode", value = "出库单号")
    private String outboundCode;
    /**
    *  wms出库单号
    */
    @ApiModelProperty(name = "wmsOutboundCode", value = "wms出库单号")
    private String wmsOutboundCode;
    /**
    *  关联业务单号
    */
    @ApiModelProperty(name = "businessCode", value = "关联业务单号")
    private String businessCode;
    /**
    *  仓库
    */
    @ApiModelProperty(name = "warehouseName", value = "仓库")
    private String warehouseName;
    /**
    *  物流公司
    */
    @ApiModelProperty(name = "logisticCompany", value = "物流公司")
    private String logisticCompany;
    /**
    *  承运方式
    */
    @ApiModelProperty(name = "transportType", value = "承运方式")
    private String transportType;
    /**
    *  托运单号
    */
    @ApiModelProperty(name = "transportCode", value = "托运单号")
    private String transportCode;
    /**
    *  瓶数
    */
    @ApiModelProperty(name = "bottle", value = "瓶数")
    private BigDecimal bottle;
    /**
    *  箱数
    */
    @ApiModelProperty(name = "box", value = "箱数")
    private BigDecimal box;
    /**
    *  体积（m^3）
    */
    @ApiModelProperty(name = "volume", value = "体积（m^3）")
    private BigDecimal volume;
    /**
    *  重量（KG）
    */
    @ApiModelProperty(name = "weight", value = "重量（KG）")
    private BigDecimal weight;
    /**
    *  累计箱数
    */
    @ApiModelProperty(name = "totalBox", value = "累计箱数")
    private BigDecimal totalBox;
    /**
    *  累计体积（m^3）
    */
    @ApiModelProperty(name = "totalVolume", value = "累计体积（m^3）")
    private BigDecimal totalVolume;
    /**
    *  累计重量（KG）
    */
    @ApiModelProperty(name = "totalWeight", value = "累计重量（KG）")
    private BigDecimal totalWeight;
    /**
    *  计算方式
    */
    @ApiModelProperty(name = "chargeMode", value = "计算方式")
    private String chargeMode;
    /**
    *  运费单价
    */
    @ApiModelProperty(name = "transportPrice", value = "运费单价")
    private BigDecimal transportPrice;
    /**
    *  运费金额
    */
    @ApiModelProperty(name = "transportAmount", value = "运费金额")
    private BigDecimal transportAmount;
    /**
    *  运费单价
    */
    @ApiModelProperty(name = "minCharge", value = "运费单价")
    private BigDecimal minCharge;
    /**
    *  送货费
    */
    @ApiModelProperty(name = "deliveryAmount", value = "送货费")
    private BigDecimal deliveryAmount;
    /**
    *  卸货费
    */
    @ApiModelProperty(name = "unloadAmount", value = "卸货费")
    private BigDecimal unloadAmount;
    /**
    *  油价联动
    */
    @ApiModelProperty(name = "oilPrice", value = "油价联动")
    private BigDecimal oilPrice;
    /**
    *  特殊费用类型
    */
    @ApiModelProperty(name = "specialType", value = "特殊费用类型")
    private String specialType;
    /**
    *  特殊费用
    */
    @ApiModelProperty(name = "specialAmount", value = "特殊费用")
    private BigDecimal specialAmount;
    /**
    *  运费合计
    */
    @ApiModelProperty(name = "totalTransportAmount", value = "运费合计")
    private BigDecimal totalTransportAmount;
    /**
    *  分摊费用
    */
    @ApiModelProperty(name = "shareAmount", value = "分摊费用")
    private BigDecimal shareAmount;
    /**
    *  调出仓库
    */
    @ApiModelProperty(name = "warehouseOut", value = "调出仓库")
    private String warehouseOut;
    /**
    *  调出组织
    */
    @ApiModelProperty(name = "organizationOut", value = "调出组织")
    private String organizationOut;
    /**
    *  调入仓库
    */
    @ApiModelProperty(name = "warehouseEnter", value = "调入仓库")
    private String warehouseEnter;
    /**
    *  调入组织
    */
    @ApiModelProperty(name = "organizationEnter", value = "调入组织")
    private String organizationEnter;
    /**
    *  费用归属
    */
    @ApiModelProperty(name = "amountAttribution", value = "费用归属")
    private String amountAttribution;
    /**
    *  收获人
    */
    @ApiModelProperty(name = "harvestPeople", value = "收获人")
    private String harvestPeople;
    /**
    *  省份
    */
    @ApiModelProperty(name = "province", value = "省份")
    private String province;
    /**
    *  城市
    */
    @ApiModelProperty(name = "city", value = "城市")
    private String city;
    /**
    *  客户收获地址
    */
    @ApiModelProperty(name = "harvestAddress", value = "客户收获地址")
    private String harvestAddress;
    /**
    *  状态（0=正常 1=异常）
    */
    @ApiModelProperty(name = "status", value = "状态（0=正常 1=异常）")
    private Integer status;
    /**
    *  备注
    */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    private String warehouseEnterCode;
    private String warehouseOutCode;
    private String logisticCompanyCode;
    private String area;
}
