/**
 * @(#) GetInventoryDetailReportListPageParams.java 1.0 2022/1/5/005 Copyright (c) 2018, YUNXI. All rights
 *         reserved. YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.tcbj.api.dto.request;

import com.dtyunxi.dto.BasePageDto;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * InventoryDetailReportListPageReqDto
 * @author fengjian
 */
@ApiModel(value = "InventoryDetailReportListPageReqDto", description = "")
public class InventoryDetailReportListPageReqDto extends BasePageDto {

    @NotNull
    @ApiModelProperty(name = "pageSize", required = true, value = "")
    @JsonProperty("pageSize")
    private Integer pageSize;

    @NotNull
    @ApiModelProperty(name = "pageNum", required = true, value = "")
    @JsonProperty("pageNum")
    private Integer pageNum;


    @ApiModelProperty(name = "externalOrderNo", value = "外部单号")
    @JsonProperty("externalOrderNo")
    private String externalOrderNo;


    @ApiModelProperty(name = "sourceSystem", value = "系统来源")
    @JsonProperty("sourceSystem")
    private String sourceSystem;


    @ApiModelProperty(name = "orderType", value = "单据类型")
    @JsonProperty("orderType")
    private String orderType;


    @ApiModelProperty(name = "documentNo", value = "出入库单号")
    @JsonProperty("documentNo")
    private String documentNo;


    @ApiModelProperty(name = "businessType", value = "业务类型")
    @JsonProperty("businessType")
    private String businessType;

    @ApiModelProperty(name = "businessTypeList", value = "业务类型")
    @JsonProperty("businessTypeList")
    private List<String> businessTypeList;


    @ApiModelProperty(name = "businessOrderNo", value = "关联业务单号")
    @JsonProperty("businessOrderNo")
    private String businessOrderNo;


    @ApiModelProperty(name = "goodsLongCode", value = "商品长编码")
    @JsonProperty("goodsLongCode")
    private String goodsLongCode;


    @ApiModelProperty(name = "goodsName", value = "商品名称")
    @JsonProperty("goodsName")
    private String goodsName;


    @ApiModelProperty(name = "logicalWarehouseCode", value = "逻辑仓编码")
    @JsonProperty("logicalWarehouseCode")
    private String logicalWarehouseCode;

    @ApiModelProperty(name = "logicalWarehouseCodeList", value = "逻辑仓编码")
    @JsonProperty("logicalWarehouseCodeList")
    private List<String> logicalWarehouseCodeList;

    @ApiModelProperty(name = "physicsWarehouseCodeList", value = "物理仓编码")
    @JsonProperty("physicsWarehouseCodeList")
    private List<String> physicsWarehouseCodeList;


    @ApiModelProperty(name = "logicalWarehouseName", value = "逻辑仓名称")
    @JsonProperty("logicalWarehouseName")
    private String logicalWarehouseName;


    @ApiModelProperty(name = "cargoRightName", value = "库存组织名称")
    @JsonProperty("cargoRightName")
    private String cargoRightName;


    @ApiModelProperty(name = "createTimeStart", value = "创建时间开始")
    @JsonProperty("createTimeStart")
    private String createTimeStart;


    @ApiModelProperty(name = "createTimeEnd", value = "创建时间结束")
    @JsonProperty("createTimeEnd")
    private String createTimeEnd;

    @Override
    public Integer getPageSize() {
        return pageSize;
    }

    @Override
    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public Integer getPageNum() {
        return pageNum;
    }

    @Override
    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public String getExternalOrderNo() {
        return externalOrderNo;
    }

    public void setExternalOrderNo(String externalOrderNo) {
        this.externalOrderNo = externalOrderNo;
    }

    public String getSourceSystem() {
        return sourceSystem;
    }

    public void setSourceSystem(String sourceSystem) {
        this.sourceSystem = sourceSystem;
    }

    public String getOrderType() {
        return orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public String getDocumentNo() {
        return documentNo;
    }

    public void setDocumentNo(String documentNo) {
        this.documentNo = documentNo;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public String getBusinessOrderNo() {
        return businessOrderNo;
    }

    public void setBusinessOrderNo(String businessOrderNo) {
        this.businessOrderNo = businessOrderNo;
    }

    public String getGoodsLongCode() {
        return goodsLongCode;
    }

    public void setGoodsLongCode(String goodsLongCode) {
        this.goodsLongCode = goodsLongCode;
    }

    public String getGoodsName() {
        return goodsName;
    }

    public void setGoodsName(String goodsName) {
        this.goodsName = goodsName;
    }

    public String getLogicalWarehouseCode() {
        return logicalWarehouseCode;
    }

    public void setLogicalWarehouseCode(String logicalWarehouseCode) {
        this.logicalWarehouseCode = logicalWarehouseCode;
    }

    public String getLogicalWarehouseName() {
        return logicalWarehouseName;
    }

    public void setLogicalWarehouseName(String logicalWarehouseName) {
        this.logicalWarehouseName = logicalWarehouseName;
    }

    public String getCargoRightName() {
        return cargoRightName;
    }

    public void setCargoRightName(String cargoRightName) {
        this.cargoRightName = cargoRightName;
    }

    public String getCreateTimeStart() {
        return createTimeStart;
    }

    public void setCreateTimeStart(String createTimeStart) {
        this.createTimeStart = createTimeStart;
    }

    public String getCreateTimeEnd() {
        return createTimeEnd;
    }

    public void setCreateTimeEnd(String createTimeEnd) {
        this.createTimeEnd = createTimeEnd;
    }

    public List<String> getBusinessTypeList() {
        return businessTypeList;
    }

    public void setBusinessTypeList(List<String> businessTypeList) {
        this.businessTypeList = businessTypeList;
    }

    public List<String> getLogicalWarehouseCodeList() {
        return logicalWarehouseCodeList;
    }

    public void setLogicalWarehouseCodeList(List<String> logicalWarehouseCodeList) {
        this.logicalWarehouseCodeList = logicalWarehouseCodeList;
    }

    public List<String> getPhysicsWarehouseCodeList() {
        return physicsWarehouseCodeList;
    }

    public void setPhysicsWarehouseCodeList(List<String> physicsWarehouseCodeList) {
        this.physicsWarehouseCodeList = physicsWarehouseCodeList;
    }
}

