package com.dtyunxi.tcbj.api.dto.request;

import java.util.Date;
import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;

/**
* 客户类型Eo对象
*
* @author yuangui
* @since 2022-03-19
*/
@ApiModel(value = "CustomerTypeReqDto", description = "客户类型Eo对象")
public class PCPCustomerTypeReqDto extends RequestDto{
    /**
    *  主键
    */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;
    /**
    *  名称
    */
    @ApiModelProperty(name = "name", value = "名称")
    private String name;
    /**
    *  排序号
    */
    @ApiModelProperty(name = "sort", value = "排序号")
    private Integer sort;
    /**
    *  说明
    */
    @ApiModelProperty(name = "typeIntroduction", value = "说明")
    private String typeIntroduction;
    /**
    *  类型来源(0系统内置-1普通客户)
    */
    @ApiModelProperty(name = "customerTypeSourceType", value = "类型来源(0系统内置-1普通客户)")
    private Integer customerTypeSourceType;
    /**
    *  类型编码
    */
    @ApiModelProperty(name = "code", value = "类型编码")
    private String code;
    /**
    *  类型:1-经销商;2-零售商;3-客户
    */
    @ApiModelProperty(name = "type", value = "类型:1-经销商;2-零售商;3-客户")
    private Integer type;

    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }
    public void setName(String name){
    this.name = name;
    }
    public String getName(){
    return this.name;
    }
    public void setSort(Integer sort){
    this.sort = sort;
    }
    public Integer getSort(){
    return this.sort;
    }
    public void setTypeIntroduction(String typeIntroduction){
    this.typeIntroduction = typeIntroduction;
    }
    public String getTypeIntroduction(){
    return this.typeIntroduction;
    }
    public void setCustomerTypeSourceType(Integer customerTypeSourceType){
    this.customerTypeSourceType = customerTypeSourceType;
    }
    public Integer getCustomerTypeSourceType(){
    return this.customerTypeSourceType;
    }
    public void setCode(String code){
    this.code = code;
    }
    public String getCode(){
    return this.code;
    }
    public void setType(Integer type){
    this.type = type;
    }
    public Integer getType(){
    return this.type;
    }
}
