package com.dtyunxi.tcbj.api.dto.request;

import java.util.Date;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 仓储费用分摊表Eo对象
 *
 * @author by_liusong
 * @since 2022-07-15
 */
@ApiModel(value = "StorageChargeApportionReqDto", description = "仓储费用分摊表Eo对象")
@Data
public class StorageChargeApportionReqDto extends RequestDto {
    /**
     * 主键
     */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;
    /**
     * 统计数据月份
     */
    @ApiModelProperty(name = "recordMonth", value = "统计数据月份")
    private Date recordMonth;

    /**
     * 统计数据月份
     */
    @ApiModelProperty(name = "startRecordMonth", value = "统计数据开始月份")
    private Date startRecordMonth;

    /**
     * 统计数据月份
     */
    @ApiModelProperty(name = "endRecordMonth", value = "统计数据结束月份")
    private Date endRecordMonth;
    /**
     * 涉及统计月份，逗号隔开
     */
    @ApiModelProperty(name = "recordMonthStr", value = "涉及统计月份，逗号隔开")
    private String recordMonthStr;
    /**
     * 物理仓库编码
     */
    @ApiModelProperty(name = "physicsWarehouseCode", value = "物理仓库编码")
    private String physicsWarehouseCode;

    private List<String> physicsWarehouseCodeList;
    /**
     * 物理仓库名称
     */
    @ApiModelProperty(name = "physicsWarehouseName", value = "物理仓库名称")
    private String physicsWarehouseName;
    /**
     * 逻辑仓库编码
     */
    @ApiModelProperty(name = "logicWarehouseCode", value = "逻辑仓库编码")
    private String logicWarehouseCode;
    /**
     * 逻辑仓库名称
     */
    @ApiModelProperty(name = "logicWarehouseName", value = "逻辑仓库名称")
    private String logicWarehouseName;
    /**
     * 商品长编码
     */
    @ApiModelProperty(name = "opLongCode", value = "商品长编码")
    private String opLongCode;
    /**
     * 商品名称
     */
    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;
    /**
     * 批次
     */
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;
    /**
     * 即时库存数
     */
    @ApiModelProperty(name = "inventoryNum", value = "即时库存数")
    private Integer inventoryNum;
    /**
     * 板数
     */
    @ApiModelProperty(name = "support", value = "板数")
    private Integer support;

    /**
     * 占板数
     */
    @ApiModelProperty(name = "zhTrayNum", value = "即时库存数")
    private Integer zhTrayNum;
    /**
     * 大包系数
     */
    @ApiModelProperty(name = "bigRatio", value = "即时库存数")
    private Integer bigRatio;

    /**
     * 入库时间
     */
    @ApiModelProperty(name = "inDeliveryTime", value = "入库时间")
    private Date inDeliveryTime;
    /**
     * 货权归属组织id
     */
    @ApiModelProperty(name = "belongOrgId", value = "货权归属组织id")
    private Long belongOrgId;
    /**
     * 货权所属组织名称
     */
    @ApiModelProperty(name = "belongOrgName", value = "货权所属组织名称")
    private String belongOrgName;

    @ApiModelProperty(name = "billTime", value = "统计账单日期")
    private String billTime;
    /**
     * 组织id
     */
    @ApiModelProperty(name = "orgId", value = "组织id")
    private Long orgId;

    /**
     * 是否分摊
     */
    @ApiModelProperty(name = "is_apportion", value = "是否分摊")
    private Integer isApportion;

    /**
     * 是否需要进行二次维度校验
     */
    @ApiModelProperty(name = "is_verify", value = "是否需要进行二次维度校验")
    private Integer isVerify;

    /**
     * 分摊组织组织明细
     */
    @ApiModelProperty(name = "apportionOrgReqDtoList", value = "分摊组织明细")
    private List<ApportionOrgReqDto> apportionOrgReqDtoList;


}
