package com.dtyunxi.tcbj.api.dto.request.es;

import com.dtyunxi.tcbj.api.dto.constant.enums.YesOrNoEnum;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 库存操作流水表，如果一次库存操作中变动了N个库存字段，则会存入N条对应记录Eo对象
 *
 * @author wude
 * @since 2022-03-11
 */
@Data
@ApiModel(value = "EsInventoryOperateLogListPageParams", description = "库存操作流水表，如果一次库存操作中变动了N个库存字段，则会存入N条对应记录Eo对象")
public class EsInventoryOperateLogListPageParams extends EsBaseReqParams {
    @NotNull
    @ApiModelProperty(name = "pageSize", required = true, value = "分页大小")
    @JsonProperty("pageSize")
    private Integer pageSize;

    @NotNull
    @ApiModelProperty(name = "pageNum", required = true, value = "当前分页")
    @JsonProperty("pageNum")
    private Integer pageNum;

    /**
     * 仓库编码
     */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
//    @SearchCondition(searchType = SearchType.WILDCARD)
    private String warehouseCode;
    /**
     * 仓库名称
     */
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
//    @SearchCondition(searchType = SearchType.WILDCARD)
    private String warehouseName;
    /**
     * 仓库分类:physics-物理仓,logic-逻辑仓,virtual-虚拟仓,channel-渠道仓
     */
    @ApiModelProperty(name = "warehouseClassify", value = "仓库分类:physics-物理仓,logic-逻辑仓,virtual-虚拟仓,channel-渠道仓")
//    @SearchCondition(searchType = SearchType.EQUAL)
    private String warehouseClassify;
    /**
     * 商品长编码
     */
    @ApiModelProperty(name = "itemLongCode", value = "商品长编码")
//    @SearchCondition(searchType = SearchType.WILDCARD)
    private String itemLongCode;
    /**
     * 商品名称
     */
    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;
    /**
     * 批次
     */
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;
    /**
     * 单据类型,待定
     */
    @ApiModelProperty(name = "sourceType", value = "单据类型,待定")
//    @SearchCondition(searchType = SearchType.EQUAL)
    private String sourceType;
    /**
     * 来源单据号
     */
    @ApiModelProperty(name = "sourceNo", value = "来源单据号")
//    @SearchCondition(searchType = SearchType.WILDCARD)
    private String sourceNo;

    /**
     * 变动类型
     */
    @ApiModelProperty(name = "changeType", value = "变动类型")
//    @SearchCondition(searchType = SearchType.EQUAL)
    private String changeType;

    @ApiModelProperty(name = "changeTypeList", value = "变动类型集合")
    private List<String> changeTypeList;
    /**
     * 变更开始时间
     */
//    @SearchCondition(searchType = SearchType.RANGE,key = "changeTime",priority = 1)
    private String changeBeginTime;
    /**
     * 变更结束时间
     */
//    @SearchCondition(searchType = SearchType.RANGE,key = "changeTime",priority = 2)
    private String changeEndTime;

    @ApiModelProperty(name = "externalOrderNo", value = "外部单号")
    private String externalOrderNo;
    /**
     * 业务类型
     */
    @ApiModelProperty(name = "businessType", value = "业务类型")
//    @SearchCondition(searchType = SearchType.EQUAL)
    private String businessType;

    //    @SearchCondition(searchType = SearchType.ORDER_BY)
    private String orderBy = "createTime";

    //    @SearchCondition(searchType = SearchType.DR)
    private Integer dr = 0;

    @ApiModelProperty(name = "filterBatch", value = "过滤出待批次的：1-是，0-否,默认是")
    private Integer filterBatch = YesOrNoEnum.YES.getCode();
}
