package com.dtyunxi.tcbj.api.dto.request.es;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;
import java.util.List;

@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "EsOtherStorageOrderListPageParams", description = "其他出入库单")
public class EsOtherStorageOrderListPageParams extends EsBaseReqParams {
    @NotNull
    @ApiModelProperty(name="pageSize", required = true, value = "分页大小")
    @JsonProperty("pageSize")
    private Integer pageSize;
    @NotNull
    @ApiModelProperty(name="pageNum", required = true, value = "当前分页")
    @JsonProperty("pageNum")
    private Integer pageNum;
    @ApiModelProperty(name="storageOrderNo", value = "其他出入库单据编号")
//    @SearchCondition(searchType = SearchType.WILDCARD)
    private String storageOrderNo;

    @ApiModelProperty(name="storageOrderNoList", value = "其他出入库单据编号列表")
    @JsonProperty("storageOrderNoList")
    private List<String> storageOrderNoList;


    @ApiModelProperty(name="businessType", value = "业务类型")
//    @SearchCondition(searchType = SearchType.EQUAL)
    private String businessType;
    @ApiModelProperty(name="organization", value = "库存组织")
//    @SearchCondition(searchType = SearchType.WILDCARD)
    private String organization;
    @ApiModelProperty(name="organizationId", value = "库存组织id")
//    @SearchCondition(searchType = SearchType.EQUAL)
    private String organizationId;
    @ApiModelProperty(name="warehouseId", value = "仓库id")
    private String warehouseId;
    @ApiModelProperty(name="warehouseCode", value = "仓库编码")
//    @SearchCondition(searchType = SearchType.EQUAL)
    private String warehouseCode;
    @ApiModelProperty(name="warehouseName", value = "仓库名称")
//    @SearchCondition(searchType = SearchType.WILDCARD)
    private String warehouseName;
    @ApiModelProperty(name="customerCode", value = "客户编码")
    private String customerCode;
    @ApiModelProperty(name="customerName", value = "客户名称")
//    @SearchCondition(searchType = SearchType.WILDCARD)
    private String customerName;
    @ApiModelProperty(name="orderStatus", value = "单据状态")
//    @SearchCondition(searchType = SearchType.EQUAL)
    private String orderStatus;
    @ApiModelProperty(name="createBeginTime", value = "创建开始时间")
//    @SearchCondition(searchType = SearchType.RANGE,key = "createTime",priority = 1)
    private String createBeginTime;
    @ApiModelProperty(name="createEndTime", value = "创建结束时间")
//    @SearchCondition(searchType = SearchType.RANGE,key = "createTime",priority = 2)
    private String createEndTime;
    @ApiModelProperty(name="preOrderNo", value = "前置单号")
//    @SearchCondition(searchType = SearchType.WILDCARD)
    private String preOrderNo;

    @ApiModelProperty(name="preOrderNo", value = "前置单号集合入参")
//    @SearchCondition(searchType = SearchType.WILDCARD)
    private List<String> preOrderNoList;

    @ApiModelProperty(name="orderSrc", value = "来源类型")
//    @SearchCondition(searchType = SearchType.EQUAL)
    private String orderSrc;

//    @SearchCondition(searchType = SearchType.ORDER_BY)
    private String orderBy = "createTime";

//    @SearchCondition(searchType = SearchType.DR)
    private Integer dr = 0;

    @ApiModelProperty(name="type", value = "单据类型")
    private String type;

    @ApiModelProperty(name = "externalOrderNo", value = "外部订单号")
    private String externalOrderNo;

    /**
     * 收货人
     */
    @ApiModelProperty(name="consignee", value = "收货人")
    private String consignee;

    /**
     * 联系电话
     */
    @ApiModelProperty(name="phone", value = "联系电话")
    private String phone;

    /**
     * 详细地址
     */
    @ApiModelProperty(name="address", value = "详细地址")
    private String address;

    /**
     * 物流公司名称
     */
    @ApiModelProperty(name="shippingCompany", value = "物流公司名称")
    private String shippingCompany;
    /**
     * 物流单号
     */
    @ApiModelProperty(name="shippingCode", value = "物流单号")
    private String shippingCode;
    /**
     * 托运单号
     */
    @ApiModelProperty(name="consignmentNo", value = "托运单号")
    private String consignmentNo;
    /**
     * 承运方式
     */
    @ApiModelProperty(name="shippingType", value = "承运方式")
    private String shippingType;

    @ApiModelProperty(name = "mergeOrderNo", value = "合单单号")
    private String mergeOrderNo;

    @ApiModelProperty(name = "deliveryPhysicsWarehouseCodeList", value = "发货物理仓集合")
    private List<String> deliveryPhysicsWarehouseCodeList;

    private String provinceName;

    /**
     * 市
     */
    private String cityName;

    /**
     * 区
     */
    private String areaName;
}
