package com.dtyunxi.tcbj.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

@ApiModel(value = "ConsignmentOrderQueryRespDto", description = "运单列表对象")
@Data
public class ConsignmentOrderReportRespDto {
    /**
     *  主键id
     */
    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;
    /**
     *  运单号
     */
    @ApiModelProperty(name = "consignmentNo", value = "运单号")
    private String consignmentNo;
    /**
     *  运单类型：1:原单 2:转运单
     */
    @ApiModelProperty(name = "consignmentTypeName", value = "运单类型：1:原单 2:转运单")
    private String consignmentTypeName;
    /**
     *  wms运单号
     */
    @ApiModelProperty(name = "wmsConsignmentNo", value = "wms运单号")
    private String wmsConsignmentNo;

    /**
     *  出库结果单单号
     */
    @ApiModelProperty(name = "outResultNo", value = "出库结果单单号")
    private String outResultNo;
    /**
     *  出库通知单单号
     */
    @ApiModelProperty(name = "outNoticeNo", value = "出库通知单单号")
    private String outNoticeNo;
    /**
     *  业务单号
     */
    @ApiModelProperty(name = "businessNo", value = "业务单号")
    private String businessNo;
    /**
     *  业务类型
     */
    @ApiModelProperty(name = "businessType", value = "业务类型")
    private String businessType;

    @ApiModelProperty(name = "businessTypeName", value = "业务类型")
    private String businessTypeName;

    /**
     *  承运商名称
     */
    @ApiModelProperty(name = "carrierName", value = "承运商名称")
    private String carrierName;
    /**
     *  承运方式
     */
    @ApiModelProperty(name = "carrierType", value = "承运方式")
    private String carrierType;

    /**
     *  副托运单号(原wms运单号+原发货物理仓简码)
     */
    @ApiModelProperty(name = "secondaryConsignmentNo", value = "副托运单号(原wms运单号+原发货物理仓简码)")
    private String secondaryConsignmentNo;


    /**
     *  原wms运单号(只在运单类型为转运单才存在)
     */
    @ApiModelProperty(name = "originWmsConsignmentNo", value = "原wms运单号(只在运单类型为转运单才存在)")
    private String originWmsConsignmentNo;

    /**
     *  物理仓编码
     */
    @ApiModelProperty(name = "physicsWarehouseCode", value = "发货物理仓编码")
    private String physicsWarehouseCode;
    /**
     *  物理仓名称
     */
    @ApiModelProperty(name = "physicsWarehouseName", value = "发货物理仓名称")
    private String physicsWarehouseName;

    /**
     *  发货时间
     */
    @ApiModelProperty(name = "deliveryTime", value = "发货时间")
    private String deliveryTime;
    /**
     *  计划到达天数
     */
    @ApiModelProperty(name = "planArriveDays", value = "计划到达天数")
    private Integer planArriveDays;
    /**
     *  计划到达时间
     */
    @ApiModelProperty(name = "planArriveTime", value = "计划到达时间")
    private String planArriveTime;
    /**
     *  实际到达时间
     */
    @ApiModelProperty(name = "actualArriveTime", value = "实际到达时间")
    private String actualArriveTime;

    /**
     * 总重量
     **/
    @ApiModelProperty(name="totalWeight",value = "总重量")
    private BigDecimal totalWeight;

    /**
     * 总体积
     */
    @ApiModelProperty(name="totalVolume",value = "总体积")
    private BigDecimal totalVolume;
    /**
     * 总箱数
     **/
    @ApiModelProperty(name = "totalCartons", value = "总箱数")
    private BigDecimal totalCartons;
    /**
     * 拼箱数
     **/
    @ApiModelProperty(name = "mergeQuantity", value = "拼箱数")
    private BigDecimal mergeQuantity;

    /**
     * 已出/入库数量
     **/
    @ApiModelProperty(name = "doneQuantity", value = "已出/商品数量")
    private BigDecimal doneQuantity;
    /**
     *  运单状态，0:待出库确认, 1:正常, 2:已转运
     */
    @ApiModelProperty(name="orderStatus",value = "运单状态，0:待出库确认, 1:正常, 2:已转运")
    private String orderStatusName;

    @ApiModelProperty(name="ifTransport",value = "是否转运,1是 0否")
    private String ifTransport;

    /**
     *  转运单单号
     */
    @ApiModelProperty(name = "transferConsignmentNo", value = "转运单单号")
    private String transferConsignmentNo;
    /**
     *  转运托运单单号
     */
    @ApiModelProperty(name = "transferWmsConsignmentNo", value = "转运托运单单号")
    private String transferWmsConsignmentNo;
    @ApiModelProperty(name = "transportPhysicsWarehouseName", value = "转运物理仓")
    private String transportPhysicsWarehouseName;
    @ApiModelProperty(name = "transportPhysicsWarehouseCode", value = "转运物理仓编码")
    private String transportPhysicsWarehouseCode;
    /**
     *  原运单号(只在运单类型为转运单才存在)
     */
    @ApiModelProperty(name = "originConsignmentNo", value = "主运单号")
    private String originConsignmentNo;

    /**
     *  父运单号(只在运单类型为转运单才存在)
     */
    @ApiModelProperty(name = "parentConsignmentNo", value = "父运单号")
    private String parentConsignmentNo;
    @ApiModelProperty(name = "physicsProvinceAddress", value = "发货物理仓省市区")
    private String physicsProvinceAddress;
    @ApiModelProperty(name = "physicsDetailAddress", value = "详细地址")
    private String physicsDetailAddress;
    @ApiModelProperty(name = "physicsContacts", value = "发货物理仓联系人")
    private String physicsContacts;
    @ApiModelProperty(name = "physicsPhone", value = "发货物理仓联系电话")
    private String physicsPhone;
    @ApiModelProperty(name = "carLicenseNo", value = "车牌号")
    private String carLicenseNo;
    /**
     *  司机名称
     */
    @ApiModelProperty(name = "driverName", value = "司机名称")
    private String driverName;
    /**
     *  司机电话
     */
    @ApiModelProperty(name = "driverPhone", value = "司机电话")
    private String driverPhone;


    @ApiModelProperty(name = "waybillPerson", value = "运单收货人")
    private String waybillPerson;

    @ApiModelProperty(name = "waybillPhone", value = "运单收货人联系电话")
    private String waybillPhone;


    @ApiModelProperty(name = "mainConsignmentNo", value = "运单收货省市区")
    private String waybillProvinceAddress;

    @ApiModelProperty(name = "waybillDetailAddress", value = "运单收货详细地址")
    private String waybillDetailAddress;
    @ApiModelProperty(name = "contacts", value = "收货人")
    private String contacts;
    @ApiModelProperty(name = "phone", value = "收货人联系电话")
    private String phone;
    @ApiModelProperty(name = "provinceAddress", value = "收货省市区")
    private String provinceAddress;
    @ApiModelProperty(name = "address", value = "收货详细地址")
    private String address;
    @ApiModelProperty(name = "updateTime", value = "更新时间")
    private String updateTime;
    @ApiModelProperty(name = "updateTime", value = "创建时间")
    private String createTime;
    @ApiModelProperty(name = "mergeOrderNo", value = "合单号")
    private String mergeOrderNo;
    @ApiModelProperty(name = "externalOrderNo", value = "外部单号")
    private String externalOrderNo;
}
