package com.dtyunxi.tcbj.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Value;

import java.math.BigDecimal;

/**
 * @author minyue
 * @description: 授信账单汇总
 * @since 2022-01-12 17:01
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "CreditStatementStatisticsRespDto", description = "授信账单汇总")
public class CreditStatementStatisticsRespDto extends ReportBrandBaseRespDto {

    @ApiModelProperty(name = "creditAmount", value = "总授信额度")
    private BigDecimal creditAmount;

    @ApiModelProperty(name = "remainingAvailableAmount", value = "剩余可用额度")
    private BigDecimal remainingAvailableAmount;

    @ApiModelProperty(name = "usedAmount", value = "已用授信额度")
    private BigDecimal usedAmount;

    @ApiModelProperty(name = "billNumbers", value = "账单笔数")
    private Integer billNumbers;

    @ApiModelProperty(name = "totalAmountDue", value = "应还总金额")
    private BigDecimal totalAmountDue;

    @ApiModelProperty(name = "usedReturnAmount", value = "已还金额")
    private BigDecimal usedReturnAmount;

    @ApiModelProperty(name = "outStandingAmount", value = "未还金额")
    private BigDecimal outStandingAmount;
}
