package com.dtyunxi.tcbj.api.dto.response;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 首页统计，发货、未发货情况统计响应DTO
 */
@Data
public class HomeStatisticsDeliverRespDto {

    @ApiModelProperty(name = "date", value = "统计时间")
    private String date;

    @ApiModelProperty(name = "physicsWarehouseCode", value = "物理仓编码")
    private String physicsWarehouseCode;

    @ApiModelProperty(name = "physicsWarehouseName", value = "物理仓名称")
    private String physicsWarehouseName;

    @ApiModelProperty(name = "saleOrderNum", value = "销售单数量")
    private Integer saleOrderNum = 0;

    @ApiModelProperty(name = "saleOrderVolume", value = "销售单体积")
    private BigDecimal saleOrderVolume = BigDecimal.ZERO;

    @ApiModelProperty(name = "transferOrderNum", value = "调拨单数量")
    private Integer transferOrderNum = 0;

    @ApiModelProperty(name = "transferOrderVolume", value = "调拨单体积")
    private BigDecimal transferOrderVolume = BigDecimal.ZERO;

    @ApiModelProperty(name = "nutritionOrderNum", value = "营养家单数量")
    private Integer nutritionOrderNum = 0;

    @ApiModelProperty(name = "nutritionOrderVolume", value = "营养家单体积")
    private BigDecimal nutritionOrderVolume = BigDecimal.ZERO;

    @ApiModelProperty(name = "otherOrderNum", value = "其他出单数量")
    private Integer otherOrderNum = 0;

    @ApiModelProperty(name = "otherOrderVolume", value = "其他出单体积")
    private BigDecimal otherOrderVolume = BigDecimal.ZERO;
}
