package com.dtyunxi.tcbj.api.dto.response;

import java.util.Date;
import com.dtyunxi.dto.ResponseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.List;

import com.dtyunxi.dto.BaseRespDto;

/**
* 入货结果单（已废弃）Eo对象
*
* @author by_liusong
* @since 2022-07-20
*/
@ApiModel(value = "InResultOrderRespDto", description = "入货结果单（已废弃）Eo对象")
public class InResultOrderRespDto extends BaseRespDto{
    /**
    *  主键id
    */
    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;
    /**
    *  入库结果单号
    */
    @ApiModelProperty(name = "documentNo", value = "入库结果单号")
    private String documentNo;
    /**
    *  关联单据号
    */
    @ApiModelProperty(name = "relevanceNo", value = "关联单据号")
    private String relevanceNo;
    /**
    *  前置单号
    */
    @ApiModelProperty(name = "preOrderNo", value = "前置单号")
    private String preOrderNo;
    /**
    *  外部单号
    */
    @ApiModelProperty(name = "externalOrderNo", value = "外部单号")
    private String externalOrderNo;
    /**
    *  WMS单号
    */
    @ApiModelProperty(name = "wmsOrderNo", value = "WMS单号")
    private String wmsOrderNo;
    /**
    *  业务类型
    */
    @ApiModelProperty(name = "businessType", value = "业务类型")
    private String businessType;
    /**
    *  业务单据表名
    */
    @ApiModelProperty(name = "relevanceTableName", value = "业务单据表名")
    private String relevanceTableName;
    /**
    *  单据状态,待定
    */
    @ApiModelProperty(name = "orderStatus", value = "单据状态,待定")
    private String orderStatus;
    /**
    *  入库店铺ID
    */
    @ApiModelProperty(name = "shopId", value = "入库店铺ID")
    private Long shopId;
    /**
    *  入库店铺编码
    */
    @ApiModelProperty(name = "shopCode", value = "入库店铺编码")
    private String shopCode;
    /**
    *  入库店铺名称
    */
    @ApiModelProperty(name = "shopName", value = "入库店铺名称")
    private String shopName;
    /**
    *  入库仓库ID
    */
    @ApiModelProperty(name = "warehouseId", value = "入库仓库ID")
    private Long warehouseId;
    /**
    *  入库仓库编码
    */
    @ApiModelProperty(name = "warehouseCode", value = "入库仓库编码")
    private String warehouseCode;
    /**
    *  入库仓库名称
    */
    @ApiModelProperty(name = "warehouseName", value = "入库仓库名称")
    private String warehouseName;
    /**
    *  仓库分类,physics-物理仓,logic-逻辑仓
    */
    @ApiModelProperty(name = "warehouseClassify", value = "仓库分类,physics-物理仓,logic-逻辑仓")
    private String warehouseClassify;
    /**
    *  出库仓库ID
    */
    @ApiModelProperty(name = "outWarehouseId", value = "出库仓库ID")
    private Long outWarehouseId;
    /**
    *  出库仓库编码
    */
    @ApiModelProperty(name = "outWarehouseCode", value = "出库仓库编码")
    private String outWarehouseCode;
    /**
    *  出库仓库名称
    */
    @ApiModelProperty(name = "outWarehouseName", value = "出库仓库名称")
    private String outWarehouseName;
    /**
    *  出库仓库分类,physics-物理仓,logic-逻辑仓
    */
    @ApiModelProperty(name = "outWarehouseClassify", value = "出库仓库分类,physics-物理仓,logic-逻辑仓")
    private String outWarehouseClassify;
    /**
    *  入库逻辑仓库编码
    */
    @ApiModelProperty(name = "inLogicWarehouseCode", value = "入库逻辑仓库编码")
    private String inLogicWarehouseCode;
    /**
    *  入库逻辑仓库名称
    */
    @ApiModelProperty(name = "inLogicWarehouseName", value = "入库逻辑仓库名称")
    private String inLogicWarehouseName;
    /**
    *  出库仓库编码
    */
    @ApiModelProperty(name = "outLogicWarehouseCode", value = "出库仓库编码")
    private String outLogicWarehouseCode;
    /**
    *  出库仓库名称
    */
    @ApiModelProperty(name = "outLogicWarehouseName", value = "出库仓库名称")
    private String outLogicWarehouseName;
    /**
    *  出库总数量
    */
    @ApiModelProperty(name = "totalQuantity", value = "出库总数量")
    private BigDecimal totalQuantity;
    /**
    *  拼箱数
    */
    @ApiModelProperty(name = "mergeQuantity", value = "拼箱数")
    private BigDecimal mergeQuantity;
    /**
    *  物流公司编码，SF=顺丰、EMS=标准快递、EYB=经济快件、ZJS=宅急送、YTO=圆通、ZTO=中通 (ZTO)、HTKY=百世汇通、BSKY=百世快运、BSKY=百世快运、UC=优速、STO=申通、TTKDEX=天天快递、QFKD=全峰、FAST=快捷、POSTB=邮政小包、GTO=国通、YUNDA=韵达、JD=京东配送、DD=当当宅配、AMAZON=亚马逊物流、DBWL=德邦物流、DBKD=德邦快递、DBKY=德邦快运、RRS=日日顺、OTHER=其他，(只传英文编码)
    */
    @ApiModelProperty(name = "shippingCompanyCode", value = "物流公司编码，SF=顺丰、EMS=标准快递、EYB=经济快件、ZJS=宅急送、YTO=圆通、ZTO=中通 (ZTO)、HTKY=百世汇通、BSKY=百世快运、BSKY=百世快运、UC=优速、STO=申通、TTKDEX=天天快递、QFKD=全峰、FAST=快捷、POSTB=邮政小包、GTO=国通、YUNDA=韵达、JD=京东配送、DD=当当宅配、AMAZON=亚马逊物流、DBWL=德邦物流、DBKD=德邦快递、DBKY=德邦快运、RRS=日日顺、OTHER=其他，(只传英文编码)")
    private String shippingCompanyCode;
    /**
    *  物流公司名称
    */
    @ApiModelProperty(name = "shippingCompany", value = "物流公司名称")
    private String shippingCompany;
    /**
    *  物流公司运单号（存储母单号）
    */
    @ApiModelProperty(name = "shippingCode", value = "物流公司运单号（存储母单号）")
    private String shippingCode;
    /**
    *  备注
    */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    /**
    *  组织ID
    */
    @ApiModelProperty(name = "organizationId", value = "组织ID")
    private Long organizationId;
    /**
    *  组织名称
    */
    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;
    /**
    *  版本：0.迁移旧数据，1.一期迭代二，2.二期
    */
    @ApiModelProperty(name = "version", value = "版本：0.迁移旧数据，1.一期迭代二，2.二期")
    private Integer version;

    @ApiModelProperty(name = "inResultOrderDetailRespDtoList", value = "入库结果单明细")
    private List<InResultOrderDetailRespDto> inResultOrderDetailRespDtoList;

    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }
    public void setDocumentNo(String documentNo){
    this.documentNo = documentNo;
    }
    public String getDocumentNo(){
    return this.documentNo;
    }
    public void setRelevanceNo(String relevanceNo){
    this.relevanceNo = relevanceNo;
    }
    public String getRelevanceNo(){
    return this.relevanceNo;
    }
    public void setPreOrderNo(String preOrderNo){
    this.preOrderNo = preOrderNo;
    }
    public String getPreOrderNo(){
    return this.preOrderNo;
    }
    public void setExternalOrderNo(String externalOrderNo){
    this.externalOrderNo = externalOrderNo;
    }
    public String getExternalOrderNo(){
    return this.externalOrderNo;
    }
    public void setWmsOrderNo(String wmsOrderNo){
    this.wmsOrderNo = wmsOrderNo;
    }
    public String getWmsOrderNo(){
    return this.wmsOrderNo;
    }
    public void setBusinessType(String businessType){
    this.businessType = businessType;
    }
    public String getBusinessType(){
    return this.businessType;
    }
    public void setRelevanceTableName(String relevanceTableName){
    this.relevanceTableName = relevanceTableName;
    }
    public String getRelevanceTableName(){
    return this.relevanceTableName;
    }
    public void setOrderStatus(String orderStatus){
    this.orderStatus = orderStatus;
    }
    public String getOrderStatus(){
    return this.orderStatus;
    }
    public void setShopId(Long shopId){
    this.shopId = shopId;
    }
    public Long getShopId(){
    return this.shopId;
    }
    public void setShopCode(String shopCode){
    this.shopCode = shopCode;
    }
    public String getShopCode(){
    return this.shopCode;
    }
    public void setShopName(String shopName){
    this.shopName = shopName;
    }
    public String getShopName(){
    return this.shopName;
    }
    public void setWarehouseId(Long warehouseId){
    this.warehouseId = warehouseId;
    }
    public Long getWarehouseId(){
    return this.warehouseId;
    }
    public void setWarehouseCode(String warehouseCode){
    this.warehouseCode = warehouseCode;
    }
    public String getWarehouseCode(){
    return this.warehouseCode;
    }
    public void setWarehouseName(String warehouseName){
    this.warehouseName = warehouseName;
    }
    public String getWarehouseName(){
    return this.warehouseName;
    }
    public void setWarehouseClassify(String warehouseClassify){
    this.warehouseClassify = warehouseClassify;
    }
    public String getWarehouseClassify(){
    return this.warehouseClassify;
    }
    public void setOutWarehouseId(Long outWarehouseId){
    this.outWarehouseId = outWarehouseId;
    }
    public Long getOutWarehouseId(){
    return this.outWarehouseId;
    }
    public void setOutWarehouseCode(String outWarehouseCode){
    this.outWarehouseCode = outWarehouseCode;
    }
    public String getOutWarehouseCode(){
    return this.outWarehouseCode;
    }
    public void setOutWarehouseName(String outWarehouseName){
    this.outWarehouseName = outWarehouseName;
    }
    public String getOutWarehouseName(){
    return this.outWarehouseName;
    }
    public void setOutWarehouseClassify(String outWarehouseClassify){
    this.outWarehouseClassify = outWarehouseClassify;
    }
    public String getOutWarehouseClassify(){
    return this.outWarehouseClassify;
    }
    public void setInLogicWarehouseCode(String inLogicWarehouseCode){
    this.inLogicWarehouseCode = inLogicWarehouseCode;
    }
    public String getInLogicWarehouseCode(){
    return this.inLogicWarehouseCode;
    }
    public void setInLogicWarehouseName(String inLogicWarehouseName){
    this.inLogicWarehouseName = inLogicWarehouseName;
    }
    public String getInLogicWarehouseName(){
    return this.inLogicWarehouseName;
    }
    public void setOutLogicWarehouseCode(String outLogicWarehouseCode){
    this.outLogicWarehouseCode = outLogicWarehouseCode;
    }
    public String getOutLogicWarehouseCode(){
    return this.outLogicWarehouseCode;
    }
    public void setOutLogicWarehouseName(String outLogicWarehouseName){
    this.outLogicWarehouseName = outLogicWarehouseName;
    }
    public String getOutLogicWarehouseName(){
    return this.outLogicWarehouseName;
    }
    public void setTotalQuantity(BigDecimal totalQuantity){
    this.totalQuantity = totalQuantity;
    }
    public BigDecimal getTotalQuantity(){
    return this.totalQuantity;
    }
    public void setMergeQuantity(BigDecimal mergeQuantity){
    this.mergeQuantity = mergeQuantity;
    }
    public BigDecimal getMergeQuantity(){
    return this.mergeQuantity;
    }
    public void setShippingCompanyCode(String shippingCompanyCode){
    this.shippingCompanyCode = shippingCompanyCode;
    }
    public String getShippingCompanyCode(){
    return this.shippingCompanyCode;
    }
    public void setShippingCompany(String shippingCompany){
    this.shippingCompany = shippingCompany;
    }
    public String getShippingCompany(){
    return this.shippingCompany;
    }
    public void setShippingCode(String shippingCode){
    this.shippingCode = shippingCode;
    }
    public String getShippingCode(){
    return this.shippingCode;
    }
    public void setRemark(String remark){
    this.remark = remark;
    }
    public String getRemark(){
    return this.remark;
    }
    public void setOrganizationId(Long organizationId){
    this.organizationId = organizationId;
    }
    public Long getOrganizationId(){
    return this.organizationId;
    }
    public void setOrganizationName(String organizationName){
    this.organizationName = organizationName;
    }
    public String getOrganizationName(){
    return this.organizationName;
    }
    public void setVersion(Integer version){
    this.version = version;
    }
    public Integer getVersion(){
    return this.version;
    }

    public List<InResultOrderDetailRespDto> getInResultOrderDetailRespDtoList() {
        return inResultOrderDetailRespDtoList;
    }

    public void setInResultOrderDetailRespDtoList(List<InResultOrderDetailRespDto> inResultOrderDetailRespDtoList) {
        this.inResultOrderDetailRespDtoList = inResultOrderDetailRespDtoList;
    }
}
