package com.dtyunxi.tcbj.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.Email;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.util.Date;

/**
* 由于主数据版本的大差异问题，为支持导出功能，在这里拷贝了主数据的导出功能，后续该类视情况会废除，如果其他人使用也可
* @author lshaowu
* @time 2022/7/22 15:56
* @description
*/
@ApiModel(value = "OrganizationInfoExtTemporaryDto", description = "组织信息扩展临时类")
@Data
public class OrganizationInfoExtTemporaryDto {

    @ApiModelProperty(name = "orgId", value = "组织id")
    private Long orgId;

    @ApiModelProperty("执照类型,1:多证合一营业执照,2:普通营业执照")
    private Integer businessLicenseType;
    @ApiModelProperty("营业期限类型,1:短期有效，2：长期有效")
    private String businessTermType;
    @ApiModelProperty("营业期限类型,1:短期有效，2：长期有效")
    private Date termBeginTime;
    @ApiModelProperty("营业期限类型,1:短期有效，2：长期有效")
    private Date termEndTime;


    @ApiModelProperty("法人证件类型,1:大陆居民省份证，2：港澳台，3：护照")
    private Integer legalCardType;

    @ApiModelProperty("法人证件有效期类型，1:短期有效，2：长期有效")
    private Integer cardEffectType;
    @ApiModelProperty("法人证件有效期开始时间")
    private Date cardEffectBeginTime;
    @ApiModelProperty("法人证件有效期结束时间")
    private Date cardEffectEndTime;

    @ApiModelProperty("经营资质")
    private String businessQualification;

    @ApiModelProperty( name = "settleStatus", value = "入驻状态（1：未入驻、2：申请中、3：已入驻(启用)、4：禁用）")
    private Integer settleStatus;

    @ApiModelProperty("主体类型（company：企业，individual：个体户，zooid：个人）")
    private String subjectType;
    @ApiModelProperty("id")
    private Long id;
    @NotNull(
            message = "统一社会信用代码不能为null"
    )
    @ApiModelProperty("统一社会信用代码，新增必填")
    private String creditCode;
    @NotNull(
            message = "组织名称不能为null"
    )
    @ApiModelProperty("组织名称，新增必填")
    private String orgName;
    @ApiModelProperty("公司地址，选填")
    private String address;
    @NotNull(
            message = "法人姓名不能为null"
    )
    @ApiModelProperty("法人姓名，新增必填")
    private String legalName;
    @ApiModelProperty("注册资本，选填")
    private String registeredCapital;
    @ApiModelProperty("机构类型，选填")
    private String orgType;
    @ApiModelProperty("经营范围，选填")
    private String busiScope;
    @DateTimeFormat(
            iso = DateTimeFormat.ISO.DATE
    )
    @ApiModelProperty("企业注册日期，选填")
    private Date foundingTime;
    @ApiModelProperty("用户Id")
    private Long userId;
    @NotNull(
            message = "组织编号不能为null"
    )
    @ApiModelProperty("组织编号，新增必填")
    private String orgCode;
    @ApiModelProperty("简称，选填")
    private String simpleName;
    @ApiModelProperty("邮编，选填")
    private String postcode;
    @ApiModelProperty("传真，选填")
    private String fax;
    @ApiModelProperty("员工数量，选填")
    private String staffNum;
    @ApiModelProperty("法人证件号码，选填")
    private String legalCardNum;
    @ApiModelProperty("身份证正面，选填")
    private String idCardFront;
    @ApiModelProperty("身份证反面，选填")
    private String idCardBack;
    @ApiModelProperty("联系人，选填")
    private String linkman;
    @Pattern(
            regexp = "^1[0-9]{10}$",
            message = "联系电话格式错误"
    )
    @ApiModelProperty("联系电话，选填")
    private String phoneNum;
    @Pattern(
            regexp = "0[0-9]{2,3}\\-[1-9][0-9]{6,7}",
            message = "公司电话格式错误"
    )
    @ApiModelProperty("公司电话，选填")
    private String companyTel;
    @Email
    @ApiModelProperty("公司邮箱，选填")
    private String companyEmail;
    @ApiModelProperty("营业执照URL，选填")
    private String bussinessLicenseUrl;
    @ApiModelProperty("法人身份证，选填")
    private String legalManCard;
    @ApiModelProperty("银行开户名，选填")
    private String accountName;
    @ApiModelProperty("开户行卡号，选填")
    private String accountNum;
    @ApiModelProperty("开户行支行名称，选填")
    private String branchAccountName;
    @ApiModelProperty("开户行支行联行号，选填")
    private String branchAccountNum;
    @ApiModelProperty("企业logoURL，选填")
    private String logoUrl;
    @ApiModelProperty("组织机构代码证号，选填")
    private String orgCertNo;
    @ApiModelProperty("税务登记号，选填")
    private String taxNo;
    @ApiModelProperty("营业执照号，选填")
    private String businessLicenseNo;
}
