package com.dtyunxi.tcbj.api.dto.response;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 销售结果单明细
 */
@Data
public class SaleResultOrderDetailRespDto {

    @ApiModelProperty(name = "id",value = "结果明细ID")
    private String id;

    @ApiModelProperty(name = "tradeOrderItemId",value = "源商品行明细id")
    private Long tradeOrderItemId;

    private String documentNo;

    private String cargoCode;

    private String longCode;

    private String cargoName;

    private String batch;

    private Date produceTime;

    private Date expireTime;

    private Long quantity;

    @ApiModelProperty(name = "taxPrice",value = "含税单价（折前价）")
    private BigDecimal taxPrice;

    @ApiModelProperty(name = "taxLastMoney",value = "含税总价（折前总价）")
    private BigDecimal taxLastMoney;

    @ApiModelProperty(name = "taxRate",value = "税率")
    private BigDecimal taxRate;

    @ApiModelProperty(name = "actualTaxPrice",value = "折后单价（实际价）")
    private BigDecimal actualTaxPrice;

    @ApiModelProperty(name = "actualTotalPrice",value = "折后总价")
    private BigDecimal actualTotalPrice;

    @ApiModelProperty(name = "discountAmount",value = "折扣额")
    private BigDecimal discountAmount;

    @ApiModelProperty(value = "销售单出仓/销售红单入仓")
    private String warehouseCode;

    private String extension;

    private String sourceBillEntryId;

    @ApiModelProperty(value = "是否赠品")
    private Integer ifGift;

    @ApiModelProperty(value = "是否积分产品")
    private Integer ifIntegral;

    @ApiModelProperty(value = "使用积分")
    private String totalScore;

    @ApiModelProperty(name = "salePrice",value = "供货单价（含税）")
    private BigDecimal salePrice;

    @ApiModelProperty(name = "actuallyAmount",value = "明细实付总额（含税）")
    private Double actuallyAmount;

    @ApiModelProperty(name = "payableAmount",value = "明细应付总额（含税）")
    private Double payableAmount;

    @ApiModelProperty(name = "giftInfoList",value = "礼盒信息")
    private List<Object> giftInfoList;

}
