package com.dtyunxi.tcbj.api.dto.response;

import java.util.Date;
import com.dtyunxi.dto.ResponseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import com.dtyunxi.dto.BaseRespDto;

/**
* TMS签收统计Eo对象
*
* @author 天泽
* @since 2022-08-24
*/
@ApiModel(value = "TmsSignForStatisticsRespDto", description = "TMS签收统计Eo对象")
public class TmsSignForStatisticsRespDto extends BaseRespDto{
    /**
    *  主键
    */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;
    /**
    *  物理仓编码
    */
    @ApiModelProperty(name = "warehouseCode", value = "物理仓编码")
    private String warehouseCode;
    /**
    *  物理仓名称
    */
    @ApiModelProperty(name = "warehouseName", value = "物理仓名称")
    private String warehouseName;
    /**
    *  单据类型
    */
    @ApiModelProperty(name = "billType", value = "单据类型")
    private String billType;
    /**
    *  超时未签收
    */
    @ApiModelProperty(name = "overtimeNotSigned", value = "超时未签收")
    private Long overtimeNotSigned;
    /**
    *  正常在途
    */
    @ApiModelProperty(name = "intransit", value = "正常在途")
    private Long intransit;
    /**
    *  正常签收
    */
    @ApiModelProperty(name = "signed", value = "正常签收")
    private Long signed;
    /**
    *  超时签收
    */
    @ApiModelProperty(name = "overtimeSigned", value = "超时签收")
    private Long overtimeSigned;
    /**
     *  异常
     */
    @ApiModelProperty(name = "abnormal", value = "异常数据")
    private Long abnormal ;

    public Long getAbnormal() {
        return abnormal;
    }

    public void setAbnormal(Long abnormal) {
        this.abnormal = abnormal;
    }

    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }
    public void setWarehouseCode(String warehouseCode){
    this.warehouseCode = warehouseCode;
    }
    public String getWarehouseCode(){
    return this.warehouseCode;
    }
    public void setWarehouseName(String warehouseName){
    this.warehouseName = warehouseName;
    }
    public String getWarehouseName(){
    return this.warehouseName;
    }
    public void setBillType(String billType){
    this.billType = billType;
    }
    public String getBillType(){
    return this.billType;
    }
    public void setOvertimeNotSigned(Long overtimeNotSigned){
    this.overtimeNotSigned = overtimeNotSigned;
    }
    public Long getOvertimeNotSigned(){
    return this.overtimeNotSigned;
    }
    public void setIntransit(Long intransit){
    this.intransit = intransit;
    }
    public Long getIntransit(){
    return this.intransit;
    }
    public void setSigned(Long signed){
    this.signed = signed;
    }
    public Long getSigned(){
    return this.signed;
    }
    public void setOvertimeSigned(Long overtimeSigned){
    this.overtimeSigned = overtimeSigned;
    }
    public Long getOvertimeSigned(){
    return this.overtimeSigned;
    }
}
