package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.OrderOccupyItemReqDto;
import com.dtyunxi.tcbj.api.dto.response.OrderOccupyItemRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

/**
 * @author shuyi
 * @date : 2021/12/7 17:25
 * @since 1.0.0
 */
@Api(tags = {"报表中心：查询订单商品信息"})
@FeignClient(
        name = "${tcbj.center.report.api.name:tcbj-center-report}",
        path = "/v1/order",
        url = "${tcbj.center.report.api:}"
)
public interface IOrderItemReportQueryApi {

    /**
     * 订单产品明细库存使用查询
     * @param reqDto
     */
    @PostMapping(value = {"/item/queryOrderOccupyItem"}, produces = "application/json")
    @ApiOperation(value = "订单产品明细库存使用查询", notes = "订单产品明细库存使用查询")
    RestResponse<List<OrderOccupyItemRespDto>> queryOrderInfoByCargoCode(@RequestBody OrderOccupyItemReqDto reqDto);

}
