package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 用户组织接口
 *
 */
@Api(tags = {"用户组织接口"})
@FeignClient(name = "${tcbj.center.report.name:tcbj-center-report}",
        path = "/v1/organizationExpand",
        url = "${tcbj.center.report.api:}")
public interface IOrganizationExpandQueryApi {

    @PostMapping("/queryOrgDtoByIds")
    @ApiOperation(value = "根据组织idList查询组织信息", notes = "根据组织idList查询组织信息")
    RestResponse<List<OrganizationDto>> queryOrgDtoByIds(@RequestBody List<Long> orgIds);
}
