package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.BatchInversionReqDto;
import com.dtyunxi.tcbj.api.dto.request.PcpItemReqDto;
import com.dtyunxi.tcbj.api.dto.response.BatchInversionRespDto;
import com.dtyunxi.tcbj.api.dto.response.PcpItemRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

/**
* 货品服务接口
*
* @author yuangui
* @since 2022-05-26
*/
@Api(tags = {"货品服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-query-IPcpItemQueryApi",
    name = "${tcbj.center.report.api.name:tcbj-center-report}",
    path = "/v1/pcpItem",
    url = "${tcbj.center.report.api:}"
)
public interface IPcpItemQueryApi {

    /**
    * 根据id查询货品
    *
    * @param id 货品id
    * @return   货品数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询货品", notes = "根据id查询货品")
    RestResponse<PcpItemRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 货品分页数据
    *
    * @param filter   货品查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 货品分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "货品分页数据", notes = "根据filter查询条件查询货品数据，filter=PcpItemReqDto")
    RestResponse<PageInfo<PcpItemRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 根据物料查询批次倒挂报表信息
     * @param reqDto
     * @return
     */
    @PostMapping("/queryItemByBatchInversion")
    @ApiOperation(value = "根据物料查询批次倒挂报表信息", notes = "根据物料查询批次倒挂报表信息，filter=PcpItemReqDto")
    RestResponse<PageInfo<BatchInversionRespDto>> queryItemByBatchInversion(@RequestBody BatchInversionReqDto reqDto);
}
