package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.response.RpAllotLoseEfficacyConfigRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.GetMapping;
import com.github.pagehelper.PageInfo;

/**
* 近效期配置表服务接口
*
* @author jiejun
* @since 2022-10-14
*/
@Api(tags = {"近效期配置表服务"})
@FeignClient(
        name = "${tcbj.center.report.api.name:tcbj-center-report}",
        path = "/v1/rpAllotLoseEfficacyConfig",
        url = "${tcbj.center.report.api:}"
)
public interface IRpAllotLoseEfficacyConfigQueryApi {

    /**
    * 根据id查询近效期配置表
    *
    * @param id 近效期配置表id
    * @return   近效期配置表数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询近效期配置表", notes = "根据id查询近效期配置表")
    RestResponse<RpAllotLoseEfficacyConfigRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 近效期配置表分页数据
    *
    * @param filter   近效期配置表查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 近效期配置表分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "近效期配置表分页数据", notes = "根据filter查询条件查询近效期配置表数据，filter=RpAllotLoseEfficacyConfigReqDto")
    RestResponse<PageInfo<RpAllotLoseEfficacyConfigRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 默认查询近效期配置表
     * @param pageSize 逻辑仓库分页数量
     * @return 处理结果
     */
    @GetMapping("/queryDefault")
    @ApiOperation(value = "默认查询近效期配置表", notes = "默认查询近效期配置表")
    RestResponse<RpAllotLoseEfficacyConfigRespDto> queryDefault(Integer pageSize);

}
