package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;

import com.dtyunxi.tcbj.api.dto.request.RpAllotLoseEfficacyWarehouseReqDto;
import com.dtyunxi.tcbj.api.dto.response.RpAllotLoseEfficacyWarehouseRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

/**
* 近效期仓库配置表服务接口
*
* @author jiejun
* @since 2022-10-14
*/
@Api(tags = {"近效期仓库配置表服务"})
@FeignClient(
        name = "${tcbj.center.report.api.name:tcbj-center-report}",
        path = "/v1/rpAllotLoseEfficacyWarehouse",
        url = "${tcbj.center.report.api:}"
)
public interface IRpAllotLoseEfficacyWarehouseQueryApi {

    /**
    * 根据id查询近效期仓库配置表
    *
    * @param id 近效期仓库配置表id
    * @return   近效期仓库配置表数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询近效期仓库配置表", notes = "根据id查询近效期仓库配置表")
    RestResponse<RpAllotLoseEfficacyWarehouseRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 近效期仓库配置表分页数据
    *
    * @param filter   近效期仓库配置表查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 近效期仓库配置表分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "近效期仓库配置表分页数据", notes = "根据filter查询条件查询近效期仓库配置表数据，filter=RpAllotLoseEfficacyWarehouseReqDto")
    RestResponse<PageInfo<RpAllotLoseEfficacyWarehouseRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 近效期仓库配置表分页查询
     * @param reqDto 请求参数
     * @return 处理结果
     */
    @PostMapping("/queryByPageList")
    @ApiOperation(value = "近效期仓库配置表分页查询", notes = "近效期仓库配置表分页查询")
    RestResponse<PageInfo<RpAllotLoseEfficacyWarehouseRespDto>> queryByPageList(@RequestBody RpAllotLoseEfficacyWarehouseReqDto reqDto);

}
