package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.OrderPushInterceptRecordReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@Api(tags = {"单据推送外部系统拦截记录服务"})
@FeignClient(
        contextId = "com-dtyunxi-tcbj-api-IOrderPushInterceptRecordApi",
        name = "${tcbj.center.report.api.name:tcbj-center-report}",
        path = "/v1/orderPushInterceptRecordApi",
        url = "${tcbj.center.report.api:}"
)
public interface IOrderPushInterceptRecordApi {

    @ApiOperation(value = "新增单据推送外部系统拦截记录", notes = "新增单据推送外部系统拦截记录")
    @PostMapping("/add")
    RestResponse<Long> add(@RequestBody OrderPushInterceptRecordReqDto reqDto);

}
