package com.dtyunxi.tcbj.api.dto.constant.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.Objects;

public enum ChannelEnum {
    KEY( "KEY", "TEXTS"),
    AH_FX( "AH-FX", "携泰-直营"),
    BH( "BH", "佰弘渠道"),
    BJDS001( "BJDS001", "佰嘉电商"),
    CZ_JX( "CZ-JX", "经销商"),
    DS( "DS", "电商"),
    EC( "EC", "电商"),
    ES_JLD( "ES-JLD", "佰嘉电商-健力多"),
    ES_LS( "ES-LS", "佰嘉电商-Life-Space"),
//    ES_LS( "ES-LS", "佰嘉电商-益倍适"),
    ES_WXN( "ES-WXN", "佰嘉电商-无限能"),
    HX( "HX", "会销"),
    JS( "JS", "区域客户"),
    KA( "KA", "KA"),
    LATENCY( "LATENCY", "潜在经销商"),
    MLQD( "MLQD", "麦浪渠道"),
    MRMJQD( "MRMJQD", "每日每加渠道"),
    MY_JS( "MY-JS", "麦优-经销"),
    MYQD( "MYQD", "麦优渠道"),
    P( "P", "药线"),
    P_JLD( "P-JLD", "药线-健力多"),
    P_LS( "P-LS", "药线-Life-Space"),
    P_WXN( "P-WXN", "药线-无限能"),
    QLQD( "QLQD", "轻乐渠道"),
    QT_DS( "QT-DS", "其他-电商"),
    S( "S", "商超"),
    S_JLD( "S-JLD", "商超-健力多"),
    S_LS( "S-LS", "商超-Life-Space"),
    S_NBTY( "S-NBTY", "商超-健之宝"),
    S_WXN( "S-WXN", "商超-无限能"),
    SC( "SC", "商超"),
    SP( "SP", "药线和商超"),
    SP_JLD( "SP-JLD", "药线和商超-健力多"),
    SP_WXN( "SP-WXN", "药线和商超-无限能"),
    STRATEGIC( "STRATEGIC", "战略经销商"),
    T001( "T001", "药线"),
    TV( "TV", "TV"),
    XLS_JLD( "XLS-JLD", "新零售-健力多"),
    YS( "YS", "药线"),
    YT( "YT", "婴童"),
    YTES( "YTES", "婴童电商"),
    ZD( "ZD", "终端"),
    ZD_JLD( "ZD-JLD", "终端-健力多"),
    ZD_LS( "ZD-LS", "终端-Life-Space"),
    ZD_WXN( "ZD-WXN", "终端-无限能"),
    ;

    private String code;

    private String name;

    ChannelEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public static String getNameByCode(String code){
        if (StringUtils.isBlank(code)){
            return code;
        }
        for (ChannelEnum en : ChannelEnum.values()){
            if (en.getCode().equals(code)){
                return en.getName();
            }
        }
        return code;
    }



}
