package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.PreemptionRecordReportListPageReqDto;
import com.dtyunxi.tcbj.api.dto.response.PreemptionRecordReportPageListRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 预占记录报表服务接口
 *
 * @author fengjian
 * @since 2022-07-07
 */
@Api(tags = {"预占记录报表服务"})
@FeignClient(
        name = "${tcbj.center.report.name:tcbj-center-report}",
        path = "/v1/preemptionRecordReport",
        url = "${tcbj.center.report.api:}"
)
public interface IPreemptionRecordReportQueryApi {

    /**
     * 预占记录报表分页列表
     *
     * @param dto 参数类
     * @return 预占记录报表分页列表
     */
    @PostMapping("")
    @ApiOperation(value = "预占记录报表分页列表", notes = "根据filter查询条件查询预占记录报表分页列表，filter=PreemptionRecordReportListPageReqDto")
    RestResponse<PageInfo<PreemptionRecordReportPageListRespDto>> queryPreemptionRecordReport(@RequestBody PreemptionRecordReportListPageReqDto dto);

    @GetMapping("executeJob")
    RestResponse<Void> executeJob();

    @GetMapping("executeJobTest")
    RestResponse<Void> executeJobTest(@RequestParam(name = "beginDate") String beginDate, @RequestParam(name = "endDate")String endDate);

}
