package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.response.TmsSignForStatisticsRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * TMS签收统计服务接口
 *
 * @author 天泽
 * @since 2022-08-24
 */
@Api(tags = {"TMS签收统计服务"})
@FeignClient(
        contextId = "com-dtyunxi-tcbj-api-query-ITmsSignForStatisticsQueryApi",
        name = "${tcbj.center.report.name:tcbj-center-report}",
        path = "/v1/tmsSignForStatistics",
        url = "${tcbj.center.report.api:}"
)
public interface ITmsSignForStatisticsQueryApi {

    /**
     * 根据id查询TMS签收统计
     *
     * @param id TMS签收统计id
     * @return TMS签收统计数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询TMS签收统计", notes = "根据id查询TMS签收统计")
    RestResponse<TmsSignForStatisticsRespDto> queryById(@PathVariable("id") Long id);

    /**
     * TMS签收统计分页数据
     *
     * @param filter   TMS签收统计查询条件
     * @param pageNum  当前页
     * @param pageSize 页大小
     * @return TMS签收统计分页数据
     */
    @GetMapping("/page")
    @ApiOperation(value = "TMS签收统计分页数据", notes = "根据filter查询条件查询TMS签收统计数据，filter=TmsSignForStatisticsReqDto")
    RestResponse<PageInfo<TmsSignForStatisticsRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                                    @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                    @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * TMS签收统计数据
     *
     * @param billType TMS签收统计查询条件
     * @return TMS签收统计分页数据
     */
    @GetMapping("/queryTmsSignForStatistics")
    @ApiOperation(value = "TMS签收统计数据", notes = "TMS签收统计数据，billType=CsPcpBusinessTypeEnum")
    RestResponse<List<TmsSignForStatisticsRespDto>> queryTmsSignForStatistics(@RequestParam(value = "billType", required = false) String billType);

}
