package com.dtyunxi.tcbj.api.dto.constant.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

public enum  ApportionOrderEnum {

    SALE("sale","销售单"),
    SALE_REFUND("saleRefund","销售退单"),
    INTERNAL_DEAL("internal_deal","调拨单（内部交易）"),
    ROUTE_INTERNAL_DEAL("route_internal_deal","调拨单（在途内部交易）"),
    INTERNAL_DEAL_RETURN("internal_deal_return","调拨单（内部交易退）"),
    SALE_RETURN_INTERNAL_DEAL("sale_return_internal_deal","调拨单（销售退转内部交易）"),
    SALE_TRANSFER("allot_sale","销售调拨"),

    ;

    private final String code;
    private final String value;

    ApportionOrderEnum(String code, String value) {
        this.code = code;
        this.value = value;
    }

    public static ApportionOrderEnum getByCode(String type){
        return StringUtils.isBlank(type) ? null : (ApportionOrderEnum) Arrays.stream(values()).filter((e) -> {
            return e.getCode().equals(type);
        }).findAny().orElse((ApportionOrderEnum) null);
    }

    public String getCode() {
        return code;
    }

    public String getValue() {
        return value;
    }
}
