/**
 * @(#) InlineObject.java 1.0 2022/1/5/005
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.tcbj.api.dto.request;

import com.dtyunxi.tcbj.api.dto.entity.BasePageDto;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * SecurityCodeReportReqDto
 */
@Data
public class SecurityCodeReportReqDto extends BasePageDto {
  @NotNull 
  @ApiModelProperty(name="pageSize", required = true, value = "分页大小")
  @JsonProperty("pageSize")
  private Integer pageSize;
  
  @NotNull 
  @ApiModelProperty(name="pageNum", required = true, value = "当前页码")
  @JsonProperty("pageNum")
  private Integer pageNum;
  
  
  @ApiModelProperty(name="businessType", value = "业务类型")
  @JsonProperty("businessType")
  private String businessType;
  
  
  @ApiModelProperty(name="businessOrderNo", value = "关联业务单号")
  @JsonProperty("businessOrderNo")
  private String businessOrderNo;
  
  
  @ApiModelProperty(name="documentNo", value = "出库结果单号")
  @JsonProperty("documentNo")
  private String documentNo;
  
  
  @ApiModelProperty(name="goodsLongCode", value = "商品长编码")
  @JsonProperty("goodsLongCode")
  private String goodsLongCode;
  
  
  @ApiModelProperty(name="goodsName", value = "商品名称")
  @JsonProperty("goodsName")
  private String goodsName;
  
  
  @ApiModelProperty(name="logicalWarehouseCode", value = "逻辑仓编码")
  @JsonProperty("logicalWarehouseCode")
  private String logicalWarehouseCode;
  
  
  @ApiModelProperty(name="logicalWarehouseName", value = "逻辑仓名称")
  @JsonProperty("logicalWarehouseName")
  private String logicalWarehouseName;
  
  
  @ApiModelProperty(name="strandCode", value = "串码")
  @JsonProperty("strandCode")
  private String strandCode;
  
  
  @ApiModelProperty(name="securityCode", value = "防伪码")
  @JsonProperty("securityCode")
  private String securityCode;
  
  
  @ApiModelProperty(name="createTimeStart", value = "创建时间开始")
  @JsonProperty("createTimeStart")
  private String createTimeStart;
  
  
  @ApiModelProperty(name="createTimeEnd", value = "创建时间结束")
  @JsonProperty("createTimeEnd")
  private String createTimeEnd;
  
  
  @ApiModelProperty(name="deliveryTimeStart", value = "发货日期开始")
  @JsonProperty("deliveryTimeStart")
  private String deliveryTimeStart;
  
  
  @ApiModelProperty(name="deliveryTimeEnd", value = "发货日期结束")
  @JsonProperty("deliveryTimeEnd")
  private String deliveryTimeEnd;

  @ApiModelProperty(name="easSaleOrderNo", value = "eas单号")
  @JsonProperty("easSaleOrderNo")
  private String easSaleOrderNo;
  
}

