package com.dtyunxi.tcbj.api.dto.response;

import java.util.Date;
import com.dtyunxi.dto.ResponseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import com.dtyunxi.dto.BaseRespDto;

/**
* 仓库出库统计Eo对象
*
* @author 天泽
* @since 2022-08-24
*/
@ApiModel(value = "WarehouseIssueStatisticsRespDto", description = "仓库出库统计Eo对象")
public class WarehouseIssueStatisticsRespDto extends BaseRespDto{
    /**
    *  主键
    */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;
    /**
    *  下单日期
    */
    @ApiModelProperty(name = "saleCreateDate", value = "下单日期")
    private String saleCreateDate;
    /**
    *  物理仓编码
    */
    @ApiModelProperty(name = "warehouseCode", value = "物理仓编码")
    private String warehouseCode;
    /**
    *  物理仓名称
    */
    @ApiModelProperty(name = "warehouseName", value = "物理仓名称")
    private String warehouseName;
    /**
    *   未发货订单票数
    */
    @ApiModelProperty(name = "notIssuedNum", value = " 未发货订单票数")
    private Long notIssuedNum;
    /**
    *  未发货订单体积
    */
    @ApiModelProperty(name = "notIssuedVolume", value = "未发货订单体积")
    private BigDecimal notIssuedVolume;
    /**
    *  已发货订单票数
    */
    @ApiModelProperty(name = "issuedNumber", value = "已发货订单票数")
    private Long issuedNumber;
    /**
    *  已发货订单体积
    */
    @ApiModelProperty(name = "issuedVolume", value = "已发货订单体积")
    private BigDecimal issuedVolume;
    /**
     * 调拨单 未发货订单票数
     */
    @ApiModelProperty(name = "trNotIssuedNum", value = "【调拨单】或【其他出库】 未发货订单票数")
    private Long trNotIssuedNum;
    /**
     * 调拨单未发货订单体积
     */
    @ApiModelProperty(name = "trNotIssuedVolume", value = "【调拨单】或【其他出库】 未发货订单体积")
    private BigDecimal trNotIssuedVolume;
    /**
     * 调拨单已发货订单票数
     */
    @ApiModelProperty(name = "trIssuedNumber", value = "【调拨单】或【其他出库】 已发货订单票数")
    private Long trIssuedNumber;
    /**
     * 调拨单已发货订单体积
     */
    @ApiModelProperty(name = "trIssuedVolume", value = "【调拨单】或【其他出库】 发货订单体积")
    private BigDecimal trIssuedVolume;

    public Long getTrNotIssuedNum() {
        return trNotIssuedNum;
    }

    public void setTrNotIssuedNum(Long trNotIssuedNum) {
        this.trNotIssuedNum = trNotIssuedNum;
    }

    public BigDecimal getTrNotIssuedVolume() {
        return trNotIssuedVolume;
    }

    public void setTrNotIssuedVolume(BigDecimal trNotIssuedVolume) {
        this.trNotIssuedVolume = trNotIssuedVolume;
    }

    public Long getTrIssuedNumber() {
        return trIssuedNumber;
    }

    public void setTrIssuedNumber(Long trIssuedNumber) {
        this.trIssuedNumber = trIssuedNumber;
    }

    public BigDecimal getTrIssuedVolume() {
        return trIssuedVolume;
    }

    public void setTrIssuedVolume(BigDecimal trIssuedVolume) {
        this.trIssuedVolume = trIssuedVolume;
    }

    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }

    public String getSaleCreateDate() {
        return saleCreateDate;
    }

    public void setSaleCreateDate(String saleCreateDate) {
        this.saleCreateDate = saleCreateDate;
    }

    public void setWarehouseCode(String warehouseCode){
    this.warehouseCode = warehouseCode;
    }
    public String getWarehouseCode(){
    return this.warehouseCode;
    }
    public void setWarehouseName(String warehouseName){
    this.warehouseName = warehouseName;
    }
    public String getWarehouseName(){
    return this.warehouseName;
    }
    public void setNotIssuedNum(Long notIssuedNum){
    this.notIssuedNum = notIssuedNum;
    }
    public Long getNotIssuedNum(){
    return this.notIssuedNum;
    }

    public BigDecimal getNotIssuedVolume() {
        return notIssuedVolume;
    }

    public void setNotIssuedVolume(BigDecimal notIssuedVolume) {
        this.notIssuedVolume = notIssuedVolume;
    }

    public Long getIssuedNumber() {
        return issuedNumber;
    }

    public void setIssuedNumber(Long issuedNumber) {
        this.issuedNumber = issuedNumber;
    }

    public void setIssuedVolume(BigDecimal issuedVolume){
    this.issuedVolume = issuedVolume;
    }
    public BigDecimal getIssuedVolume(){
    return this.issuedVolume;
    }
}
