package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;

import com.dtyunxi.tcbj.api.dto.request.StringCheckResultReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
* 串码校验结果服务接口
*
* @author author
* @since 2022-09-22
*/
@Api(tags = {"串码校验结果服务"})
@FeignClient(name = "${tcbj.center.report.name:tcbj-center-report}", path = "/v1/stringCheck/log", url = "${tcbj.center.report.api:}")
public interface IStringCheckResultApi {

    /**
    * 新增串码校验结果
    *
    * @param addReqDto 串码校验结果请求对象
    * @return 处理结果
    */
    @PostMapping("")
    @ApiOperation(value = "新增串码校验结果", notes = "新增串码校验结果")
    RestResponse<Long> addStringCheckResult(@RequestBody StringCheckResultReqDto addReqDto);

    /**
    * 修改串码校验结果
    *
    * @param modifyReqDto 串码校验结果请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改串码校验结果", notes = "修改串码校验结果")
    RestResponse<Void> modifyStringCheckResult(@RequestBody StringCheckResultReqDto modifyReqDto);

    /**
    * 删除串码校验结果
    *
    * @param ids        串码校验结果删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除串码校验结果", notes = "删除串码校验结果")
    RestResponse<Void> removeStringCheckResult(@PathVariable("ids") String ids,@RequestParam("instanceId") Long instanceId);
}
