package com.dtyunxi.tcbj.api.dto.constant.enums;

import java.util.HashMap;
import java.util.Map;

public enum BusinessTypeCodeEnum {
    SOURCE_ORDER("source_order", "寻源单"),
    ORDER_SALES_OUT("order_sales_out", "订单销售出库"),
    ORDER_SALES_REFUND("order_sales_refund", "订单销售退"),
    ALLOT_OUT("allot_out", "调拨单（普通调拨）"),
    INTERNAL_DEAL("internal_deal", "调拨单（内部交易）"),
    INSPECTION_QUALIFIED("inspection_qualified", "调拨单（待检转合格）"),
    ALLOT_LOSE_EFFICACY("allot_lose_efficacy", "调拨单（近效期/失效期商品调拨）"),
    ALLOT_BC_EFFICACY("allot_bc_efficacy", "调拨单（B-C调拨）"),
    ALLOT_LOGIC_OUT("allot_logic_out", "逻辑调拨"),
    PURCHASE("purchase", "采购促销物料入库"),
    OUTSOURCE("outsource", "委外成品入库"),
    PRODUCTION("production", "生产成品入库"),
    PURCHASE_REFUND("purchase_refund", "采购订单退货"),
    OUTSOURCE_REFUND("outsource_refund", "委外订单退货"),
    OTHER_IN("other_in", "其他入库"),
    OTHER_OUT("other_out", "其他出库"),
    BATCH_ADJUST("batch_adjust", "批次号调整"),
    CHECK_STOCK("check_stock", "盘点单"),
    DISTRIBUTE_ORDER("distribute_order", "分货单"),
    INVENTORY_ADJUST("inventory_adjust", "库存调整"),
    INTERNAL_DEAL_RETURN("internal_deal_return", "内部交易退"),
    SALE_RETURN_INTERNAL_DEAL("sale_return_internal_deal", "销售退转内部交易"),
    ALLOT_OUT_ONLY("allot_out_only", "库存调拨单（调拨出库）"),
    ALLOT_IN_ONLY("allot_in_only", "库存调拨单（调拨入库）"),
    AGENCY_ORDER("agency_order", "经销订单"),
    INTEGRAL_ORDER("integral_order", "经销商积分"),
    SHOPPE_ORDER("shoppe_order", "专柜订单"),
    REPLENISHMENT_ORDER("replenishment_order", "货补订单"),
    ACTIVITY_ORDER("activity_order", "活动订单"),
    CUSTOMER_REFUNDING_ORDER("customer_refunding_order", "消费者退换货"),
    COMPENSATION_ORDER("compensation_order", "索赔补发"),
    QUALITY_REFUNDING_ORDER("quality_refunding_order", "质量退换货"),
    REPLENISH_ORDER("replenish_order", "少货补发"),
    COMMON_ORDER("common_order", "普通订单"),
    PRODUCT_REPAIR("product_repair", "生产返修退厂单"),
    INTERNAL_DISTRIBUTION("internal_distribution", "内部分销"),
    CLAIM_REISSUE("claim_reissue", "仓库索赔补发"),
    CLAIM_POSTING("claim_posting", "仓库索赔过账"),
    NUTRITION_INTEGRAL("nutrition_integral", "营养家积分"),
    IN_TRANSIT_ADJUSTMENT_OUT("in_transit_adjustment_out", "在途库存出库"),
    IN_TRANSIT_ADJUSTMENT_IN ("in_transit_adjustment_in", "在途库存入库"),
    IN_TRANSIT_TRANSFER ("in_transit_transfer", "在途转合格"),
    PCP_OUT_SALE_PREEMPT("pcp_out_sale_preempt", "销售出库预占"),
    PCP_OUT_SALE_RELEASE("pcp_out_sale_release", "销售出库释放"),
    OUT_SALE_PREEMPT ("out_sale_preempt", "下单预占"),
    IN_TO_ADJUST("in_to_adjust", "调整单（入库）增加"),
    SECONDARY_DISTRIBUTION("secondary_distribution", "二级分销"),
    OTHER_OUT_STOCK("other_out_stock", "其他出库单"),
    PRESALE_ORDER("presale_order", "预售订单"),
    OUT_ALLOT_PREEMPT("out_allot_preempt", "调拨出库预占"),
    OUT_SALE("out_sale", "销售出库"),
    LOCK_INVENTORY ("lock_inventory", "锁定库存"),
    OUT_SEPARATE("out_separate", "分销出库"),
    OUT_SEPARATE_PREEMPT("out_separate_preempt", "分销出库预占"),
    OUT_BACKTRACK("out_backtrack", "退换货出库"),
    OUT_BACKTRACK_PREEMPT("out_backtrack_preempt", "退换货出库预占"),
    OUT_TOP_BACKTRACK("out_top_backtrack", "一级退换货出库"),
    OUT_TOP_BACKTRACK_PREEMPT ("out_top_backtrack_preempt", "一级退换货出库预占"),
    SECOND_OUT_TOP_BACKTRACK("second_out_top_backtrack", "二级退换货出库"),
    SECOND_OUT_TOP_BACKTRACK_PREEMPT("second_out_top_backtrack_preempt", "二级退换货出库预占"),
    OUT_ALLOT("out_allot", "调拨出库"),
    OUT_OTHER("out_other", "其他出库"),
    OUT_OTHER_PREEMPT("out_other_preempt", "其他出库预占"),
    OUT_OTHER_RELEASE("out_other_release", "其他出库释放"),
    OUT_MATERIAL_ADJUST("out_material_adjust", "物料调整出库"),
    OUT_MATERIAL_ADJUST_PREEMPT ("out_material_adjust_preempt", "物料调整出库预占"),
    OUT_SCRAP("out_scrap", "报废出库"),
    OUT_ACT_ORDER_PREEMPT("out_act_order_preempt", "活动下单预占"),
    OUT_ACT_DELIVER_DEDUCTION("out_act_deliver_deduction", "活动发货扣减"),
    OUT_ACT_AUDIT_PREEMPT("out_act_audit_preempt", "活动审批预占"),
    OUT_BUSINESS_APPROVE_PREEMPT ("out_business_approve_preempt", "业务审批预占"),
    OUT_FINANCE_APPROVE_PREEMPT("out_finance_approve_preempt", "财务审批预占"),
    OUT_INTERIOR_ADJUST("out_interior_adjust", "内部调整出库"),
    OUT_INTERIOR_ADJUST_PREEMPT("out_interior_adjust_preempt", "内部调整出库预占"),
    OUT_TO_ADJUST("out_to_adjust", "调整单（出库）减少"),
    BATCH_ADJUSTMENT_SUBMITTED_PREEMPT("batch_adjustment_submitted_preempt", "批次调整单预占"),
    INVENTORY_ADJUSTMENT_SUBMITTED_PREEMPT("inventory_adjustment_submitted_preempt", "库存调整单预占"),
    IN_PURCHASE("in_purchase", "采购入库"),
    IN_SEPARATE("in_separate", "分销入库"),
    IN_BACKTRACK("in_backtrack", "退换货入库"),
    IN_DOWN_BACKTRACK("in_down_backtrack", "下级退换货入库"),
    IN_ALLOT("in_allot", "调拨入库"),
    IN_OTHER("in_other", "其他入库"),
    IN_MATERIAL_ADJUST("in_material_adjust", "物料调整入库"),
    IN_SALE_RELEASE("in_sale_release", "释放下单的预占"),
    SECOND_IN_PURCHASE("second_in_purchase", "二级采购入库"),
    IN_BUSINESS_APPROVE_RELEASE("in_business_approve_release", "业务审批释放"),
    IN_FINANCE_APPROVE_RELEASE("in_finance_approve_release", "财务审批释放"),
    IN_ORDER_CATCH_RELEASE("in_order_catch_release", "订单捕获异常释放"),
    IN_ACT_CANCEL_PREEMPT("in_act_cancel_preempt", "活动取消预占"),
    IN_ACT_FINISH_BACKTRACK("in_act_finish_backtrack", "活动结束归还"),
    IN_ACT_AUDIT_RELEASE("in_act_audit_release", "活动审批释放"),
    BATCH_ADJUSTMENT_RELEASE("batch_adjustment_release", "批次调整单释放"),
    INVENTORY_ADJUSTMENT_SUBMITTED_PREEMPT_RELEASE("inventory_adjustment_submitted_preempt_release", "库存调整单预占释放"),
    INITIALIZE_INVENTORY("initialize_inventory", "库存初始化"),
    CHECK_INVENTORY("check_inventory", "盘点入库"),
    OUT_SALE_REFUND("out_sale_refund", "销售退入库"),
    PURCHASE_REFUND_PREEMPT("purchase_refund_preempt", "采购退货预占"),
    PURCHASE_REFUND_PREEMPT_RELEASE("purchase_refund_preempt_release", "采购退货预占释放"),
    OUTSOURCE_REFUND_PREEMPT("outsource_refund_preempt", "委外退货预占"),
    OUTSOURCE_REFUND_PREEMPT_RELEASE("outsource_refund_preempt_release", "委外退货预占释放"),
    PURCHASE_CANCEL("purchase_cancel", "采购入库取消"),
    PURCHASE_RETREAT_CANCEL("purchase_retreat_cancel", "采购退货取消"),
    SURPLUS("surplus", "盘盈"),
    DISH("dish", "盘亏"),
    DISH_PREEMPT("dish_preempt", "盘亏预占"),
    DISH_PREEMPT_RELEASE("dish_preempt_release", "盘亏预占释放"),
    TRANSFER_ORDER("transfer_order", "调拨入库"),
    OUT_ALLOT_RELEASE("out_allot_release", "调拨单释放"),
    UNLOCK_INVENTORY("unlock_inventory", "锁库单解锁"),
    ALLOT_ONLY_RECORD("allot_only_record", "库存调拨单（仅记录）"),
    CHILD_DIRECT_SALES("child_direct_sales", "子公司直销"),
    CC_ALLOT("cc_allot", "cc调拨"),
    BC_ALLOT("bc_allot", "bc调拨"),
    CB_ALLOT("cb_allot", "cb调拨"),
    ALLOT_SALE("allot_sale", "销售调拨"),
    CS_ORDER_SALE("cs_order_sale","销售单"),
    ALLOT_SALE_BH("allot_sale_bh", "销售补货调拨"),
    OUT("out","出库结果单"),
    IN("in","入库结果单"),
    BAIJIAN_DIRECT_SALES("baijian_direct_sales", "佰健直销")

    ,MAIYOU_ALLOT_OUT("maiyou_allot_out", "库存调拨单"),
    MAIYOU_BC_ALLOT("maiyou_bc_allot", "麦优bc跨组织调拨"),

    ;

    private String code;
    private String text;
    public static Map<String, String> DELIVER_STATUS_MAP = new HashMap(values().length);

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    private BusinessTypeCodeEnum(String code, String text) {
        this.code = code;
        this.text = text;
    }

    public static String getMsgByCode(String code) {
        if (code == null) {
            return "";
        } else {
            BusinessTypeCodeEnum[] var1 = values();
            int var2 = var1.length;

            for(int var3 = 0; var3 < var2; ++var3) {
                BusinessTypeCodeEnum deliverStatusEnum = var1[var3];
                if (deliverStatusEnum.code.equals(code)) {
                    return deliverStatusEnum.text;
                }
            }

            return "";
        }
    }

    static {
        BusinessTypeCodeEnum[] var0 = values();
        int var1 = var0.length;

        for(int var2 = 0; var2 < var1; ++var2) {
            BusinessTypeCodeEnum value = var0[var2];
            DELIVER_STATUS_MAP.put(value.getCode(), value.getText());
        }

    }
}
