package com.dtyunxi.tcbj.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 平台订单统计dto
 *
 * @author haoxiao
 * @since 2022-03-10
 */
@Data
@ApiModel(value = "PlatformOrderCountRespDto", description = "平台订单统计dto")
public class PlatformOrderCountRespDto {
    /**
     * 实际库存
     */
    @ApiModelProperty(name = "allCount", value = "全部订单数量")
    private BigDecimal allCount;
    /**
     * 正常订单的数量
     */
    @ApiModelProperty(name = "normalCount", value = "正常订单的数量")
    private BigDecimal normalCount;
    /**
     * 异常订单的数量
     */
    @ApiModelProperty(name = "abnormalCount", value = "异常订单的数量")
    private BigDecimal abnormalCount;

    /**
     * 作废订单的数量
     */
    @ApiModelProperty(name = "invalidCount", value = "作废订单的数量")
    private BigDecimal invalidCount;

    /**
     * 合并订单的数量
     */
    @ApiModelProperty(name = "mergeCount", value = "合并订单的数量")
    private BigDecimal mergeCount;

    /**
     * 待转订单的数量
     */
    @ApiModelProperty(name = "waitCount", value = "待转订单的数量")
    private BigDecimal waitCount;

    /**
     * 待物流初审
     */
    @ApiModelProperty(name = "waitLogisticsCount", value = "待物流初审")
    private BigDecimal waitLogisticsCount;

    /**
     * 待仓库复审
     */
    @ApiModelProperty(name = "waitWarehouseCount", value = "待仓库复审")
    private BigDecimal waitWarehouseCount;

    /**
     * 已审核
     */
    @ApiModelProperty(name = "approvedCount", value = "已审核")
    private BigDecimal approvedCount;

}
